<?php
/**
 * User response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Response\UserIdentifier;

use AppBundle\Model\Response\Base as ResponseBase;
use AppBundle\Model\Request;

/**
 * User response base class
 */
abstract class Base extends ResponseBase
{

    /**
     * User model
     * 
     * @var \AppBundle\Entity\User
     */
    protected $user;

    /**
     * Get response for application-show
     * 
     * @param Request\Base $requestModel
     */
    public function createResponse(Request\Base $requestModel)
    {
        $this->user = $requestModel->getUserModel();
        $this->buildResponse($requestModel);
    }

}
