<?php
/**
 * User response factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Response\UserIdentifier;

use AppBundle\Model\Response\BaseFactory;
use AppBundle\Model\Response\UserIdentifier as Response;
use AppBundle\Model\Request\UserIdentifier as Request;

/**
 * User response factory
 */
class Factory extends BaseFactory
{

    /**
     * @param Request\Get $requestModel
     */
    public function get(Request\Get $requestModel)
    {
        $model = new Response\Get($this->apiM);
        $model->createResponse($requestModel);
    }

    /**
     * @param Request\Validate $requestModel
     */
    public function validate(Request\Validate $requestModel)
    {
        $model = new Response\Validate($this->apiM);
        $model->createResponse($requestModel);
    }

}
