<?php

namespace LifeStyle\Tools\SamlBundle\DependencyInjection;

use LifeStyle\Tools\SamlBundle\Saml\Configuration as SamlConfiguration;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\HttpKernel\DependencyInjection\Extension;
use Symfony\Component\DependencyInjection\Loader;

/**
 * This is the class that loads and manages your bundle configuration
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html}
 */
class LifeStyleToolsSamlExtension extends Extension
{
    /**
     * {@inheritdoc}
     */
    public function load(array $configs, ContainerBuilder $container)
    {
        $configuration = new Configuration();
        $config = $this->processConfiguration($configuration, $configs);

        $loader = new Loader\YamlFileLoader($container, new FileLocator(__DIR__.'/../Resources/config'));
        $loader->load('services.yml');

        $this->configureSamlConfiguration($config, $container);
    }

    /**
     * @param array $config
     * @param ContainerBuilder $container
     */
    private function configureSamlConfiguration(array $config, ContainerBuilder $container)
    {
        $definition = $container->getDefinition(SamlConfiguration::class);
        $definition->setArguments([
            $config['idp_public_certificate_file'],
            $config['idp_single_sign_on_url'],
            $config['idp_logout_url'],
            $config['idp_request_prefix'],
            $config['sp_return_url'],
            $config['sp_issuer'],
            $config['requested_name_id_format'],
            $config['cookie_path'],
        ]);
    }
}
