<?php

/**
 * Steps ServiceProvider
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Credentials;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceProvider
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceProvider
{

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("ServiceToken")
     * @Serializer\Type("string")
     * @var string
     */
    private $serviceToken;

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("ServiceName")
     * @Serializer\Type("string")
     * @var string
     */
    private $serviceName;

    /**
     * 
     * @param string $serviceToken
     * @return ServiceProvider
     */
    public function setServiceToken($serviceToken)
    {
        $this->serviceToken = (string) $serviceToken;

        return $this;
    }

    /**
     * 
     * @param string $serviceName
     * @return ServiceProvider
     */
    public function setServiceName($serviceName)
    {
        $this->serviceName = (string) $serviceName;

        return $this;
    }

}