<?php

/**
 * Steps ServiceTrigger
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Credentials;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceTrigger
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceTrigger
{

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     * @var string
     */
    private $username;

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $userIdentifier;

    /**
     * 
     * @param string $username
     * @return ServiceTrigger
     */
    public function setUsername($username)
    {
        $this->username = (string) $username;

        return $this;
    }

    /**
     * 
     * @param string $userIdentifier
     * @return ServiceTrigger
     */
    public function setUserIdentifier($userIdentifier)
    {
        $this->userIdentifier = (string) $userIdentifier;

        return $this;
    }

}