<?php

/**
 * Steps Request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\SerializationContext;

/**
 * Steps Request
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @Serializer\XmlRoot("SsoResponse")
 */
class Response
{

    /**
     *
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $status;

    /**
     *
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @Serializer\XmlElement(cdata=false)
     * @var string
     */
    private $trackid;

    /**
     *
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @Serializer\XmlElement(cdata=false)
     * @var \DateTime
     */
    private $date;

    /**
     *
     * @Serializer\Groups({"Response::UserIdentifier::Get", "Response::UserIdentifier::Validate"})
     * @Serializer\SerializedName("UserIdentifier")
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\Response\Controller\UserIdentifierController")
     * @var Response\Controller\UserIdentifierController
     */
    private $userController;

    /**
     * 
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = (true === $status || $status == 'Success') ? 'Success' : 'Failure';

        return $this;
    }

    /**
     * 
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * 
     * @param string $trackId
     * @return Response
     */
    public function setTrackId($trackId)
    {
        $this->trackid = (string) $trackId;

        return $this;
    }

    /**
     * 
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackid;
    }

    /**
     * 
     * @param \DateTime $date
     * @return Response
     */
    public function setDate(\DateTime $date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * 
     * @return \DateTime
     */
    public function getDate()
    {
        return $this->date;
    }

    /**
     * 
     * @param Response\Controller\UserIdentifierController $userController
     * @return Response
     */
    public function setUserIdentifierController(Response\Controller\UserIdentifierController $userController)
    {
        $this->userController = $userController;

        return $this;
    }

    /**
     * 
     * @return Response\Controller\UserIdentifierController
     */
    public function getUserIdentifierController()
    {
        return $this->userController;
    }

    /**
     * 
     * @return Response\Controller\ControllerInterface
     */
    public function getController()
    {
        return $this->userController;
    }

    /**
     * @return SerializationContext Description
     */
    public function getSerializationContext()
    {
        $groups = array(
            'Response::Default',
            'Response::' . $this->getController()->getName() . '::' . $this->getController()->getCurrentAction()->getName()
        );
        return SerializationContext::create()->setGroups($groups);
    }
}