<?php

/**
 * Steps Error
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Response;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps Error
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Error
{

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("ErrorCode")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorCode;

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("ErrorRef")
     * @Serializer\Type("string")
     * @var string
     */
    private $errorRef;

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("ShortMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $shortMessage;

    /**
     * @Serializer\Groups({"Response::Default"})
     * @Serializer\SerializedName("LongMessage")
     * @Serializer\Type("string")
     * @var string
     */
    private $longMessage;

    /**
     * Set error code
     * 
     * @param string $errorCode
     * @return Error
     */
    public function setErrorCode($errorCode)
    {
        $this->errorCode = (string) $errorCode;

        return $this;
    }

    /**
     * Get error code
     * 
     * @return string
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * Set error reference
     * 
     * @param string $errorRef
     * @return Error
     */
    public function setErrorRef($errorRef)
    {
        $this->errorRef = (string) $errorRef;

        return $this;
    }

    /**
     * Get error reference
     * 
     * @return string
     */
    public function gerErrorRef()
    {
        return $this->errorRef;
    }

    /**
     * Set error short message
     * 
     * @param string $shortMessage
     * @return Error
     */
    public function setShortMessage($shortMessage)
    {
        $this->shortMessage = (string) $shortMessage;

        return $this;
    }

    /**
     * Get error short message
     * 
     * @return string
     */
    public function getShortMessage()
    {
        return $this->shortMessage;
    }

    /**
     * Set error long message
     * 
     * @param string $longMessage
     * @return Error
     */
    public function setLongMessage($longMessage)
    {
        $this->longMessage = (string) $longMessage;

        return $this;
    }

    /**
     * Get error long message
     * 
     * @return string
     */
    public function getLongMessage()
    {
        return $this->longMessage;
    }

}