<?php

/**
 * Steps UserValue
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps UserValue
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class UserValue
{

    /**
     *
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * 
     * @param UserType $userType
     * @return UserValue
     */
    public function setUserType(UserType $userType)
    {
        $this->userType = $userType;

        return $this;
    }

    /**
     * 
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }
}