<?php
/**
 * Webservice credentials filter event
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Event;

use Symfony\Component\EventDispatcher\Event;

/**
 * Webservice credentials filter event
 */
class FilterCredentialsEvent extends Event
{

    /**
     * Credentials
     * 
     * @var \SimpleXMLElement
     */
    protected $credentials;

    /**
     * Constructor
     * 
     * @param \SimpleXMLElement $xmlRequest
     */
    public function __construct(\SimpleXMLElement $xmlRequest = null)
    {
        $this->credentials = $xmlRequest;
    }

    /**
     * Get whole credentials element
     * 
     * @return \SimpleXMLElement The credentials element
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * Get the service provider element
     * 
     * @return \SimpleXMLElement|null The service provider elemement, null if not exists
     */
    public function getServiceProvider()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceProvider) ? $this->credentials->ServiceProvider : null;
    }

    /**
     * Get the service trigger element
     * 
     * @return \SimpleXMLElement|null The service trigger elemement, null if not exists
     */
    public function getServiceTrigger()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceTrigger) ? $this->credentials->ServiceTrigger : null;
    }

    /**
     * Get the service country element
     * 
     * @return \SimpleXMLElement|null The service country elemement, null if not exists
     */
    public function getServiceCountry()
    {
        return null !== $this->credentials && isset($this->credentials->ServiceCountry) ? $this->credentials->ServiceCountry : null;
    }

}
