<?php
/**
 * SAML 2.0 remote SP metadata for simpleSAMLphp.
 *
 * See: http://simplesamlphp.org/docs/trunk/simplesamlphp-reference-sp-remote
 */

// To prevent from sending the whole bunch of ldap-attributes, use this list as default attributes
$_metaSpDefaultAttributes = array(
    'guid',
    'lastname',
    'firstname',
    'username',
    'email',
    'authsource',
    'useridentifier',
);

$metadata['identifierService'] = array(
    'AssertionConsumerService' => 'http://sso-idp.dh.test.life-style.de/service/',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => array(
        'guid',
        'useridentifier',
        'username',
    ),
);

$metadata['http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sso-sp.dh.test.life-style.de/simplesaml/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'certData' => 'MIIDZzCCAk+gAwIBAgIJAKIK5DQuicThMA0GCSqGSIb3DQEBCwUAMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTAeFw0xNzEwMzAxMDA3NTBaFw0yNzEwMzAxMDA3NTBaMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOkmEGD6ED+NYM1XH+f+uP3rsPnAmMKsbXfFLZ769kAvBjBOkHiQTsiabi18ElAsLkj9nqV8MzvC+x1we/Sy0TgnExF5OlxeDp4iook0L0Jq9+SqbjfNA3ahC83iq44IzqObHG6rv2BlwhytMrVvs4ZceNZtUl8qnENdHgj40po0BTSbANU7R1aJtZ1lh7C1OnvXIT84gHNnElcOHeA3S0YpME+Mqj3YRA9ntjS447Nn/hXOm4faaSw0cKjQwurZgxO8+36k4zQGC4PwPijkTWI2u89bhNkAmOgaefskFXzhSfx6WiB4kAtF/BrkHCZ5T3nU0o+maL2zKg8DRCUnZU8CAwEAAaNQME4wHQYDVR0OBBYEFO8qDyAAfz7uD+LHI5o08dKhalTPMB8GA1UdIwQYMBaAFO8qDyAAfz7uD+LHI5o08dKhalTPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAAPZHIPTFBOCkQjGtOi215Q5CzV423nAI6dVLZdpEVnK49eQEIIu304oJFsGTBRdkQwUMTPq5DR1P3bPmGGnbYj8IBLoX0ka01DH1aqTLO7wRGoQdffe4BnZBT/x8/YtaGFgHCb5DjTOIWDSEZ+W2svLHnSGihpo/C7lVdH76GB23zGDLiXnWSgKHdkSOodajBeOBDVtXSG8JAdcfNglnUFcY45jFJ19XN1P/8YVIKj7v9wM/uOCqi29O6/Dve4kKzdKCahlvyao6GLYb+QLzz1SORqY+Ijn94RqUIAgVXcou3cPL+LI6lgOkHQttoihfOsXTI792UTtKUu5EG7tkNs=',
);

$metadata['http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/metadata.php/default-sp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sso-demo-one.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/metadata.php/default-sp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sso-demo-two.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

// For development
$metadata['http://ls-sso-demo-1.loc/sso/module.php/saml/sp/metadata.php/default-sp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://ls-sso-demo-2.loc/sso/module.php/saml/sp/metadata.php/default-sp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => $_metaSpDefaultAttributes,
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-demo-2.loc/sso/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-demo-2.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-demo-2.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-demo-2.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-demo-2.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://ls-sso-launchpad.local/sso/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'Launchpad']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-launchpad.local/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'certData' => 'MIIDZzCCAk+gAwIBAgIJAKIK5DQuicThMA0GCSqGSIb3DQEBCwUAMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTAeFw0xNzEwMzAxMDA3NTBaFw0yNzEwMzAxMDA3NTBaMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOkmEGD6ED+NYM1XH+f+uP3rsPnAmMKsbXfFLZ769kAvBjBOkHiQTsiabi18ElAsLkj9nqV8MzvC+x1we/Sy0TgnExF5OlxeDp4iook0L0Jq9+SqbjfNA3ahC83iq44IzqObHG6rv2BlwhytMrVvs4ZceNZtUl8qnENdHgj40po0BTSbANU7R1aJtZ1lh7C1OnvXIT84gHNnElcOHeA3S0YpME+Mqj3YRA9ntjS447Nn/hXOm4faaSw0cKjQwurZgxO8+36k4zQGC4PwPijkTWI2u89bhNkAmOgaefskFXzhSfx6WiB4kAtF/BrkHCZ5T3nU0o+maL2zKg8DRCUnZU8CAwEAAaNQME4wHQYDVR0OBBYEFO8qDyAAfz7uD+LHI5o08dKhalTPMB8GA1UdIwQYMBaAFO8qDyAAfz7uD+LHI5o08dKhalTPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAAPZHIPTFBOCkQjGtOi215Q5CzV423nAI6dVLZdpEVnK49eQEIIu304oJFsGTBRdkQwUMTPq5DR1P3bPmGGnbYj8IBLoX0ka01DH1aqTLO7wRGoQdffe4BnZBT/x8/YtaGFgHCb5DjTOIWDSEZ+W2svLHnSGihpo/C7lVdH76GB23zGDLiXnWSgKHdkSOodajBeOBDVtXSG8JAdcfNglnUFcY45jFJ19XN1P/8YVIKj7v9wM/uOCqi29O6/Dve4kKzdKCahlvyao6GLYb+QLzz1SORqY+Ijn94RqUIAgVXcou3cPL+LI6lgOkHQttoihfOsXTI792UTtKUu5EG7tkNs=',
);

$metadata['http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'Launchpad']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sso-launchpad.dh.test.life-style.de/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'certData' => 'MIIDZzCCAk+gAwIBAgIJAKIK5DQuicThMA0GCSqGSIb3DQEBCwUAMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTAeFw0xNzEwMzAxMDA3NTBaFw0yNzEwMzAxMDA3NTBaMEoxCzAJBgNVBAYTAkRFMQ8wDQYDVQQIDAZCYXllcm4xFjAUBgNVBAcMDUFzY2hhZmZlbmJ1cmcxEjAQBgNVBAoMCUxpZmVTdHlsZTCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAOkmEGD6ED+NYM1XH+f+uP3rsPnAmMKsbXfFLZ769kAvBjBOkHiQTsiabi18ElAsLkj9nqV8MzvC+x1we/Sy0TgnExF5OlxeDp4iook0L0Jq9+SqbjfNA3ahC83iq44IzqObHG6rv2BlwhytMrVvs4ZceNZtUl8qnENdHgj40po0BTSbANU7R1aJtZ1lh7C1OnvXIT84gHNnElcOHeA3S0YpME+Mqj3YRA9ntjS447Nn/hXOm4faaSw0cKjQwurZgxO8+36k4zQGC4PwPijkTWI2u89bhNkAmOgaefskFXzhSfx6WiB4kAtF/BrkHCZ5T3nU0o+maL2zKg8DRCUnZU8CAwEAAaNQME4wHQYDVR0OBBYEFO8qDyAAfz7uD+LHI5o08dKhalTPMB8GA1UdIwQYMBaAFO8qDyAAfz7uD+LHI5o08dKhalTPMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQELBQADggEBAAPZHIPTFBOCkQjGtOi215Q5CzV423nAI6dVLZdpEVnK49eQEIIu304oJFsGTBRdkQwUMTPq5DR1P3bPmGGnbYj8IBLoX0ka01DH1aqTLO7wRGoQdffe4BnZBT/x8/YtaGFgHCb5DjTOIWDSEZ+W2svLHnSGihpo/C7lVdH76GB23zGDLiXnWSgKHdkSOodajBeOBDVtXSG8JAdcfNglnUFcY45jFJ19XN1P/8YVIKj7v9wM/uOCqi29O6/Dve4kKzdKCahlvyao6GLYb+QLzz1SORqY+Ijn94RqUIAgVXcou3cPL+LI6lgOkHQttoihfOsXTI792UTtKUu5EG7tkNs=',
);



$metadata['http://pimcore/simplesaml/module.php/saml/sp/metadata.php/default-sp'] = array (
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://pimcore/simplesaml/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@berlitz.eu',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
    'certData' => 'MIIDyjCCArKgAwIBAgIJANsSbUXqSVFuMA0GCSqGSIb3DQEBBQUAMEwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdCYXZhcmlhMRYwFAYDVQQHEw1Bc2NoYWZmZW5idXJnMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE2MDgwNDA5MDY1OVoXDTI2MDgwNDA5MDY1OVowTDELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0JhdmFyaWExFjAUBgNVBAcTDUFzY2hhZmZlbmJ1cmcxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC35kWc87Xn3pM/DqHxfW8dajhjZJuUNPt5gxYcNWyINr1HhlkYkFEPzPvA4clhR9sSp1u82R1vR31fnEV9HjIh6Smqo4u51dxTXq7D/j/lTZjKVXtISjU6tR98h5O+TX0KqgFCs/DDj0t79j4UM005PSifaUhY1Bk/9my7TJE1kozcNo2QAO/Y02doaTw43DUBga4CirByGlZEkJwKzl7bF6kGBbPhiyJHhs0XlB6CK15/8FUe66jo8MjfSMgQ0W4+N+T4GIlwwl+njrXEPibUU4GBXVNZmVoAmxemZkVQuIpvyCLBkAItSrjoTZXpkTY7HKaYjLlRulkOlsInNAKXAgMBAAGjga4wgaswHQYDVR0OBBYEFPwvvVi0r3r0az73snBEsWH/MQsMMHwGA1UdIwR1MHOAFPwvvVi0r3r0az73snBEsWH/MQsMoVCkTjBMMQswCQYDVQQGEwJERTEQMA4GA1UECBMHQmF2YXJpYTEWMBQGA1UEBxMNQXNjaGFmZmVuYnVyZzETMBEGA1UEChMKTGlmZS1TdHlsZYIJANsSbUXqSVFuMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAFKon85nP0WvO9zbQCfq134twwXLC0JjrqUD+FAXHUOzdWX6wqMbX4LOh1CjlaSilly0QyCfJ/MlodDkg3EgdqTAo92fsPXsY0BFTTMLqCGQcGpUCbhCi8A8c+Wmk8UChfkqoiKpydpssi+AG7N6PFjnrsTRj5RhSu2u7G3fDB39ASBZaKl4KgfJEuIZGsUphi5c5E1YPhPOUTq831pilP2aHjTtu82sgrcLN9C5n5HJWEYHSTP9Z0fhTvCJ50/jh1yIoNcaHlbmZILOhXjzcXPdQOyIfMsoXHEPtsfLU8FiV6UZmaVCVLDzL80Za1qVUeDWQNnEVsouydLgqsOD6bI=',
);


$metadata['http://ls-sso-iam.loc'] = array (
    'entityid' => 'http://ls-sso-iam.loc',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'username',
    'userid.attribute' => 'username',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'SsoIamApplication']),
    'contacts' =>
        array (
        ),
    'metadata-set' => 'saml20-sp-remote',
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-iam.loc/sso/login_check',
                    'index' => 0,
                    'isDefault' => false,
                ),
        ),
    'SingleLogoutService' =>
        array (
        ),
    'keys' =>
        array (
            0 =>
                array (
                    'encryption' => true,
                    'signing' => false,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
            1 =>
                array (
                    'encryption' => false,
                    'signing' => true,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
        ),
);

$metadata['http://localhost:4200'] = array (
    'entityid' => 'http://localhost:4200',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'username',
    'userid.attribute' => 'username',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'SsoIamApplication']),
    'contacts' =>
        array (
        ),
    'metadata-set' => 'saml20-sp-remote',
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://localhost:4200/sso/login_check',
                    'index' => 0,
                    'isDefault' => false,
                ),
        ),
    'SingleLogoutService' =>
        array (
        ),
    'keys' =>
        array (
            0 =>
                array (
                    'encryption' => true,
                    'signing' => false,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
            1 =>
                array (
                    'encryption' => false,
                    'signing' => true,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
        ),
);


$metadata['http://sso-iam.dh.test.life-style.de'] = array (
    'entityid' => 'http://sso-iam.dh.test.life-style.de',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'username',
    'userid.attribute' => 'username',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'SsoIamApplication']),
    'contacts' =>
        array (
        ),
    'metadata-set' => 'saml20-sp-remote',
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sso-iam.dh.test.life-style.de/sso/login_check',
                    'index' => 0,
                    'isDefault' => false,
                ),
        ),
    'SingleLogoutService' =>
        array (
        ),
    'keys' =>
        array (
            0 =>
                array (
                    'encryption' => true,
                    'signing' => false,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDyjCCArKgAwIBAgIJAMT68HH+r08uMA0GCSqGSIb3DQEBBQUAMEwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdCYXZhcmlhMRYwFAYDVQQHEw1Bc2NoYWZmZW5idXJnMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYyODA4MDU1OVoXDTI4MDYyNzA4MDU1OVowTDELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0JhdmFyaWExFjAUBgNVBAcTDUFzY2hhZmZlbmJ1cmcxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC44fr9CJcAtC0c1FazMQSVI4At29JlmZMCRvpG0rDgMXnuZlaZUqLMzyhJTZ0/nAxn/RV6FxzdqtDl8xS4nSu/Tda8g6urxlYl6tQbOMC3mUz+IbwpuEtuM7R01sl1LgpO9PWezBLWko0yHcXa1HM2nQ+6Z9b520DNoPaGIjST8RA6ZWusxeaxUCHe72Om/2BUtG0wyIhKWz0Tz4ZQogm7EJ2kxg47xD87dhaEb619dPWcFdvzi9eZIZanc/ePgH6dC2uHokyqCsU81VAieVnuXwBflJZ23gTL7pKAyn+vyH2ENZwTvzqLGbWVqwK3TjjKuygJSrg4RfXh7E/7FMF1AgMBAAGjga4wgaswHQYDVR0OBBYEFGPW8ZyatMD69OLpO6RL6IdQKZahMHwGA1UdIwR1MHOAFGPW8ZyatMD69OLpO6RL6IdQKZahoVCkTjBMMQswCQYDVQQGEwJERTEQMA4GA1UECBMHQmF2YXJpYTEWMBQGA1UEBxMNQXNjaGFmZmVuYnVyZzETMBEGA1UEChMKTGlmZS1TdHlsZYIJAMT68HH+r08uMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEz/bnGl/RxteE8673+OB0mIWv6hTM3IKYJROu8v3W8OkA14DF2HgnO4qEy4uoYQw8rztAMZfJdWuSiPrxZfS2W5Is/vUQ66eER0VU6p77/xXfynC+oyR3tqHbbyuX8HE+VEe5FISjh4XEHj75pqcwyvzXIUP8ThvGungC399dPEDzTL41wdeMuFENij6EHXPPyh7DF9UyFjBdk7Gx9EXb9rXzaohtpjpihN+L8aeHDRdAuOp6p+VRQqjx7Bwsl1TdOJ1p7SumpJCPj95IRxlJrxT6awJs9CeWAD6SR1bEAwKxX9W/zHULuVMJQOHj9DrcrtTwRxbP+F+/Zty8YXtBQ=',
                ),
            1 =>
                array (
                    'encryption' => false,
                    'signing' => true,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDyjCCArKgAwIBAgIJAMT68HH+r08uMA0GCSqGSIb3DQEBBQUAMEwxCzAJBgNVBAYTAkRFMRAwDgYDVQQIEwdCYXZhcmlhMRYwFAYDVQQHEw1Bc2NoYWZmZW5idXJnMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYyODA4MDU1OVoXDTI4MDYyNzA4MDU1OVowTDELMAkGA1UEBhMCREUxEDAOBgNVBAgTB0JhdmFyaWExFjAUBgNVBAcTDUFzY2hhZmZlbmJ1cmcxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC44fr9CJcAtC0c1FazMQSVI4At29JlmZMCRvpG0rDgMXnuZlaZUqLMzyhJTZ0/nAxn/RV6FxzdqtDl8xS4nSu/Tda8g6urxlYl6tQbOMC3mUz+IbwpuEtuM7R01sl1LgpO9PWezBLWko0yHcXa1HM2nQ+6Z9b520DNoPaGIjST8RA6ZWusxeaxUCHe72Om/2BUtG0wyIhKWz0Tz4ZQogm7EJ2kxg47xD87dhaEb619dPWcFdvzi9eZIZanc/ePgH6dC2uHokyqCsU81VAieVnuXwBflJZ23gTL7pKAyn+vyH2ENZwTvzqLGbWVqwK3TjjKuygJSrg4RfXh7E/7FMF1AgMBAAGjga4wgaswHQYDVR0OBBYEFGPW8ZyatMD69OLpO6RL6IdQKZahMHwGA1UdIwR1MHOAFGPW8ZyatMD69OLpO6RL6IdQKZahoVCkTjBMMQswCQYDVQQGEwJERTEQMA4GA1UECBMHQmF2YXJpYTEWMBQGA1UEBxMNQXNjaGFmZmVuYnVyZzETMBEGA1UEChMKTGlmZS1TdHlsZYIJAMT68HH+r08uMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBAEz/bnGl/RxteE8673+OB0mIWv6hTM3IKYJROu8v3W8OkA14DF2HgnO4qEy4uoYQw8rztAMZfJdWuSiPrxZfS2W5Is/vUQ66eER0VU6p77/xXfynC+oyR3tqHbbyuX8HE+VEe5FISjh4XEHj75pqcwyvzXIUP8ThvGungC399dPEDzTL41wdeMuFENij6EHXPPyh7DF9UyFjBdk7Gx9EXb9rXzaohtpjpihN+L8aeHDRdAuOp6p+VRQqjx7Bwsl1TdOJ1p7SumpJCPj95IRxlJrxT6awJs9CeWAD6SR1bEAwKxX9W/zHULuVMJQOHj9DrcrtTwRxbP+F+/Zty8YXtBQ=',
                ),
        ),
);
