<?php
/**
 * SAML 2.0 remote SP metadata for simpleSAMLphp.
 *
 * See: http://simplesamlphp.org/docs/trunk/simplesamlphp-reference-sp-remote
 */

// To prevent from sending the whole bunch of ldap-attributes, use this list as default attributes
$_metaSpDefaultAttributes = array(
    'guid',
    'lastname',
    'firstname',
    'username',
    'email',
    'authsource',
    'useridentifier',
//    'applications', // Append list of all applications without any details
);


$metadata['lostPasswordService'] = array(
  'NameIDFormat'               => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
  'simplesaml.nameidattribute' => 'guid',
  'userid.attribute' => 'guid',
  'AssertionConsumerService' => 'http://lifestyle-lostpassword.loc',
  'attributes' => array('useridentifier'),
);
$metadata['identifierService'] = array(
  'NameIDFormat'               => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
  'simplesaml.nameidattribute' => 'guid',
  'userid.attribute' => 'guid',
  'AssertionConsumerService' => 'http://ls-sso-idp.loc/service/',
  'attributes' => array('useridentifier', 'username', 'guid', 'brutzel'),
);

$metadata['http://ls-sso-demo-1.loc/sso/module.php/saml/sp/metadata.php/default-sp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => [
        'guid',
        'lastname',
        'firstname',
        'username',
        'email',
        'applications',
    ],
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-logout.php/default-sp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml2-acs.php/default-sp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-demo-1.loc/sso/module.php/saml/sp/saml1-acs.php/default-sp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
    'certData' => 'MIIDczCCAlugAwIBAgIJAOu/o68n9ovAMA0GCSqGSIb3DQEBBQUAMC8xCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMQswCQYDVQQKEwJMUzAeFw0xODAzMDYwODA3MTlaFw0yODAzMDUwODA3MTlaMC8xCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMQswCQYDVQQKEwJMUzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALHAqUaVKqiBHyzWr8Ihrx/Qmqj8fg2CEBrTiTHZd25mkJ13jHtWaCOymPtZdlqcgUMGWaW6pf4Z6hK13GF2x48uFT0V8h4oUsu3mdNHGTH6vRkvfprlsSucvVq2XG9hr3Nq6M55NZMCAkIClRtlh8W4FZHE2wL/BYvVqaGDBcJ4EqwBpmZ2KHBAtM4R4c/SWahq4FaOYCLW8/VLY5/PY99DN1+4h5TF+ArnvdJ/SjS59mo2LHuNQXwuMWXfs8aiuwUsPO8pmx3TsARFHRoRWcveGdnyAkqnzBDdVJGEW7umbQwCfZ0uOevtGoLFvMxY8ZVTj7lF1khWG6McYa1ZFFECAwEAAaOBkTCBjjAdBgNVHQ4EFgQUjYTUN1iaAz5YizcrgB0d4p81GH8wXwYDVR0jBFgwVoAUjYTUN1iaAz5YizcrgB0d4p81GH+hM6QxMC8xCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMQswCQYDVQQKEwJMU4IJAOu/o68n9ovAMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBABcwwqb21Zs6WwVi5sBDvFnPsU5iqHLIqoMho2Tt5aUzW1UkZj6fKI6YQFYNqSdVxKlyOSeAIw0kMST7FHg0jc92vTIQ1NE8MWmB5L+TdmFdCvN7IJTuc1Q8Rod+I5aau13skD92JIcoN64/nl/guvRy58Cli8EMHhSh/OXBDGDPTz5erchBTmkzTmXe5+sUqEJqNng5yXHcrCkgX9DWOIGwBG1ewkS00BbFj/zoeNLM+ylkYkzRKsn/IXrePP2hkmDXpOaD6oQuL0qLOxyXaUQ/3ecaK2CqNAjQooOhcWOtGiOP+rvBIBHpCODtGtZZROm1elDOJuVGFvZafbZDjHI=',
);

$metadata['http://sha-sp-1.loc/simplesaml/module.php/saml/sp/metadata.php/sp1'] = array (
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sha-sp-1.loc/simplesaml/module.php/saml/sp/saml2-logout.php/sp1',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sha-sp-1.loc/simplesaml/module.php/saml/sp/saml2-acs.php/sp1',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sha-sp-1.loc/simplesaml/module.php/saml/sp/saml1-acs.php/sp1',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sha-sp-1.loc/simplesaml/module.php/saml/sp/saml2-acs.php/sp1',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sha-sp-1.loc/simplesaml/module.php/saml/sp/saml1-acs.php/sp1/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://sha-sp-2.loc/simplesaml/module.php/saml/sp/metadata.php/sp2'] = array (
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://sha-sp-2.loc/simplesaml/module.php/saml/sp/saml2-logout.php/sp2',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://sha-sp-2.loc/simplesaml/module.php/saml/sp/saml2-acs.php/sp2',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://sha-sp-2.loc/simplesaml/module.php/saml/sp/saml1-acs.php/sp2',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://sha-sp-2.loc/simplesaml/module.php/saml/sp/saml2-acs.php/sp2',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://sha-sp-2.loc/simplesaml/module.php/saml/sp/saml1-acs.php/sp2/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'webmaster@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://ls-sso-launchpad.loc/sso/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'guid',
    'userid.attribute' => 'guid',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', \SimpleSAML\Module\lifestyle\Auth\Process\WebserviceAttributes::APPLICATION_IDENTIFIER . 'Launchpad']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-launchpad.loc/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'contacts' =>
        array (
            0 =>
                array (
                    'emailAddress' => 'info@life-style.de',
                    'contactType' => 'technical',
                    'givenName' => 'Administrator',
                ),
        ),
);

$metadata['http://ls-sso-iam.loc'] = array (
    'entityid' => 'http://ls-sso-iam.loc',
    'NameIDFormat' => 'urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified',
    'simplesaml.nameidattribute' => 'username',
    'userid.attribute' => 'username',
    'attributes' => array_merge($_metaSpDefaultAttributes, ['applications', sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'SsoIamApplication']),
    'contacts' =>
        array (
        ),
    'metadata-set' => 'saml20-sp-remote',
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-iam.loc/sso/login_check',
                    'index' => 0,
                    'isDefault' => false,
                ),
        ),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-iam.loc/sso/logout',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-sso-iam.loc/sso/logout',
                ),
        ),
    'keys' =>
        array (
            0 =>
                array (
                    'encryption' => true,
                    'signing' => false,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
            1 =>
                array (
                    'encryption' => false,
                    'signing' => true,
                    'type' => 'X509Certificate',
                    'X509Certificate' => 'MIIDizCCAnOgAwIBAgIJAKd16yZm2S1tMA0GCSqGSIb3DQEBBQUAMDcxCzAJBgNVBAYTAkRFMRMwEQYDVQQIEwpTb21lLVN0YXRlMRMwEQYDVQQKEwpMaWZlLVN0eWxlMB4XDTE4MDYxMzAzMDIyM1oXDTI4MDYxMjAzMDIyM1owNzELMAkGA1UEBhMCREUxEzARBgNVBAgTClNvbWUtU3RhdGUxEzARBgNVBAoTCkxpZmUtU3R5bGUwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQC4EGbPVLCfc5VcRlp0XOQdaECMKoZHLUZIDC5otRLo7iWYotTksmW5p7DXHNvrRKs/MPxfMLBQ7lyEAtJR4M0KZSizo00f4/ZS+n+ss/xrFLrMzbxhK+EysFLE3ahD99dLMs3NNMzJwLHyE7cXOOj1Im58r3HPKp0E72+U9KiRAAittOpUDr4ORaJBd/L7lgBW4rdpSShpOo53e9HJsw364Msh2k5SfaktDeV73dbAX5Rz9Fp/4yuFrYWoTL7i6+SpODVe2/zxQiZmkbSiGVZoBOdmIjpC+0F+gC0dSaMRGYbL6i+e5dgtEGm89nRBxAQNv2pNUutl36tODRa/sNkzAgMBAAGjgZkwgZYwHQYDVR0OBBYEFLotS5Wtrslnu/Pe9Rf3pmnsH5rsMGcGA1UdIwRgMF6AFLotS5Wtrslnu/Pe9Rf3pmnsH5rsoTukOTA3MQswCQYDVQQGEwJERTETMBEGA1UECBMKU29tZS1TdGF0ZTETMBEGA1UEChMKTGlmZS1TdHlsZYIJAKd16yZm2S1tMAwGA1UdEwQFMAMBAf8wDQYJKoZIhvcNAQEFBQADggEBADyojKsAE/mfAG5YKww9D7jySnq/wcUbAnObGy629WFHWTul9QCn6sMt1clrsq8QPFmHiEWbnCQdE2VZ3jW0I40W04NsV/1ybiFh9C3i03uLcYg8jOLLCBnnNRrkvr4r/VE4yPfb2kYDA/FzxFMfE3gGmZ9qZsqaDkxlYLBV/0ZeuwJub70fesgBKHPOafFbBlSrUn8wDDVId1DiccHFX1DNaicQKtwdZm2wBP6C0k2Txx87jZbXBHPfsBsMhhVLc5NwRZBo1KABZ+Aqwe/UeiLmDiuZfYSp1mysND7285TyN/4tQgFWhP6as4OCOu3QeQVSNLgiX9+8nBG1UhLMYZ8=',
                ),
        ),
);

$metadata['http://ls-sso-wsp.loc/sso/module.php/saml/sp/metadata.php/ls-sso-idp'] = array (
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml2-logout.php/ls-sso-idp',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml2-acs.php/ls-sso-idp',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-sso-wsp.loc/sso/module.php/saml/sp/saml1-acs.php/ls-sso-idp/artifact',
                ),
        ),
    'certData' => 'MIIC4DCCAcgCCQCUlkVhbrrhsDANBgkqhkiG9w0BAQsFADAyMQswCQYDVQQGEwJERTEWMBQGA1UEBwwNQXNjaGFmZmVuYnVyZzELMAkGA1UECgwCTFMwHhcNMTkwMTA0MTQwNzI3WhcNMjkwMTAzMTQwNzI3WjAyMQswCQYDVQQGEwJERTEWMBQGA1UEBwwNQXNjaGFmZmVuYnVyZzELMAkGA1UECgwCTFMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDW/nZeCxCQSbZocCVv8GS+9umYX1ap3N0dYnE9378dS+P4tLrgCM07+zjnmJ50UxX+zIX5IdX+ifV+B8SyzIGZ3w/Ajtnh2umDA3YA9A7gewa2kTAUBKmHC0Z9XZtQyK3z0GMediymI3DmbsSkZkdymMeuhwICjhGCSBnr/MGmGuPbsDY6EPMytPUfjho1HEznJ+hreNl6WQEotWbPKglzLPbHpRK8fb76KZ8yGQ6znbcNAoXjG8MM4P1m2mekXIfGbg8Rfm+stiNJCWOaUNbdUjypO1/SVvdjV/dtOtmTl4A+1MShosZ7CLTPLWmzEK4ZrMRhlZ9fk2BN8uqRXwnXAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAK8PlokA1cpzPwuwnltbnXq3p6/VwMJIwFQfmiURnKcWHAUXJY/kdWA4SvL/kRWQpzz+pDEIHcIpZ+icNnrOiKn/eTPF0KqC6WUaxfKH+9Zc1i1CXvn2/zp6GYJ5I7cM9wGdLuArDRLpkIFkgBe8sVylH/lAHh3ilUTqiUgoBiP4iQQlVSSYeLRuAh4KxGcsQwURlPBvXZm5wjTDQtsCYi1CsNFaZjhsqUYyODaw7xUdW31Dw3eUdDT49dRYMWshDlary5S5atPg3OfuLVyBT7Hsoaw27ZT6uOaijG54AbavxUljMofTQk1bFFCxN97nXaE9Gf7N48D/DUeJo1hh7K0=',
);

$metadata['http://ls-bmz-sylius.loc/sso/module.php/saml/sp/metadata.php/sylius_admin'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, [sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'BmzSyliusAdmin']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-logout.php/sylius_admin',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-acs.php/sylius_admin',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml1-acs.php/sylius_admin',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-acs.php/sylius_admin',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml1-acs.php/sylius_admin/artifact',
                ),
        ),
    'certData' => 'MIIDljCCAf4CCQD8RMqHhmd+tTANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJERTAeFw0xOTA3MTUxNzIzNDFaFw0yOTA3MTQxNzIzNDFaMA0xCzAJBgNVBAYTAkRFMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAu3zRvKxwqojfHu1gQKtM5NdDTBDYuApJxRQhos2U8v2g85/8euUq4TRM0x26zaMWeUoabWNkUF7fcYZ8BMDrSw8ooWSSgoekpFmr7I0vqNBiEjUb24Bx4ez1HPym6xctMRU7lmpTmZfyODDoUUwAlFyz5a+VXuHT51cBCcRXoE56ahmMDjkeXvNiX/hu+kaOUKpzHEAeoxcg1Ekrp/kVgmnK4nYVDeGz97SOYHCD9TFTOKkb6llI9yOuExP49ZsA4KRjCcSyUMzVYNn9/F2PAnNHAoWrhj2HhW/WH5v9XDgHqLgc3JTQSjmfZiV8i66qM8htkYWMO2jX+C3WcIBRmnD0oZd3TTpfxm6VtAa4VMEW8EQiRKGIkoWYkgYOsGCeI+fHvbuTguaQWxF8HGppkb+gKBBKv3agARiTTGy08UvCMiwTChjTBPm5ZSUU5NJCEf5xoS4IAqyXbZq9NFtgnP8jSOP191oFLfRiAG+JdMKngM1Oj4JW7jLRe65nMnorAgMBAAEwDQYJKoZIhvcNAQELBQADggGBAKLcX7Q7F2nxzEw2qtJp5vKGmlBcZS1SN1kwWQY4u5iDl2+oXOVA499+FEEJg1mR0MmzK5vJNYMXNbVyAIO5GkG+rE0uCdSUSVdQerNXZ6PLc9QkkIF7UGHaS+umhnhfywaJ0t2VatpC/p22RNXZonS3BJIq7tjoutE8Po9xGVmq1war68P9LX/fd/bJI4akR3dbFqMFGtVgCj4eRfVw9eDjOvBgbSgR7/YWIoMGpwHt2OboL59N1RijfQpTrw2YmIh/Xza2hNh2km+JkWSmd+zVOH5CwRAElIEDQuk5GoUTFBQZ/pSClA8EpiBOqQ57PSm0EeKvN2f9FvkUIx7i0qJtBUE7fL2CrWo8tyOVofnQxM4wqjebvMQ2JRX6VApTNusxF8vnMZA0XnTKi7f+nhe3X/OwPJID239WHiv8BYpPtt+Jmg4iQTTZw7ha3NXenKElwskHgGYzuF6/33+cX20v7Qul/+iJDhLvP36G3NKC+bfSLXGvAeeLVCNLBAZYJA==',
);

$metadata['http://ls-bmz-sylius.loc/sso/module.php/saml/sp/metadata.php/sylius_shop'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, [sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'BmzSyliusShop']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-logout.php/sylius_shop',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-acs.php/sylius_shop',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml1-acs.php/sylius_shop',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml2-acs.php/sylius_shop',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-bmz-sylius.loc/sso/module.php/saml/sp/saml1-acs.php/sylius_shop/artifact',
                ),
        ),
    'certData' => 'MIIDljCCAf4CCQD8RMqHhmd+tTANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJERTAeFw0xOTA3MTUxNzIzNDFaFw0yOTA3MTQxNzIzNDFaMA0xCzAJBgNVBAYTAkRFMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAu3zRvKxwqojfHu1gQKtM5NdDTBDYuApJxRQhos2U8v2g85/8euUq4TRM0x26zaMWeUoabWNkUF7fcYZ8BMDrSw8ooWSSgoekpFmr7I0vqNBiEjUb24Bx4ez1HPym6xctMRU7lmpTmZfyODDoUUwAlFyz5a+VXuHT51cBCcRXoE56ahmMDjkeXvNiX/hu+kaOUKpzHEAeoxcg1Ekrp/kVgmnK4nYVDeGz97SOYHCD9TFTOKkb6llI9yOuExP49ZsA4KRjCcSyUMzVYNn9/F2PAnNHAoWrhj2HhW/WH5v9XDgHqLgc3JTQSjmfZiV8i66qM8htkYWMO2jX+C3WcIBRmnD0oZd3TTpfxm6VtAa4VMEW8EQiRKGIkoWYkgYOsGCeI+fHvbuTguaQWxF8HGppkb+gKBBKv3agARiTTGy08UvCMiwTChjTBPm5ZSUU5NJCEf5xoS4IAqyXbZq9NFtgnP8jSOP191oFLfRiAG+JdMKngM1Oj4JW7jLRe65nMnorAgMBAAEwDQYJKoZIhvcNAQELBQADggGBAKLcX7Q7F2nxzEw2qtJp5vKGmlBcZS1SN1kwWQY4u5iDl2+oXOVA499+FEEJg1mR0MmzK5vJNYMXNbVyAIO5GkG+rE0uCdSUSVdQerNXZ6PLc9QkkIF7UGHaS+umhnhfywaJ0t2VatpC/p22RNXZonS3BJIq7tjoutE8Po9xGVmq1war68P9LX/fd/bJI4akR3dbFqMFGtVgCj4eRfVw9eDjOvBgbSgR7/YWIoMGpwHt2OboL59N1RijfQpTrw2YmIh/Xza2hNh2km+JkWSmd+zVOH5CwRAElIEDQuk5GoUTFBQZ/pSClA8EpiBOqQ57PSm0EeKvN2f9FvkUIx7i0qJtBUE7fL2CrWo8tyOVofnQxM4wqjebvMQ2JRX6VApTNusxF8vnMZA0XnTKi7f+nhe3X/OwPJID239WHiv8BYpPtt+Jmg4iQTTZw7ha3NXenKElwskHgGYzuF6/33+cX20v7Qul/+iJDhLvP36G3NKC+bfSLXGvAeeLVCNLBAZYJA==',
);

$metadata['http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/metadata.php/pimcore_admin'] = array (
    'attributes' => array_merge($_metaSpDefaultAttributes, [sspmod_lifestyle_Auth_Process_WebserviceAttributes::APPLICATION_IDENTIFIER . 'BmzPimcoreAdmin']),
    'SingleLogoutService' =>
        array (
            0 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml2-logout.php/pimcore_admin',
                ),
            1 =>
                array (
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:SOAP',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml2-logout.php/pimcore_admin',
                ),
        ),
    'AssertionConsumerService' =>
        array (
            0 =>
                array (
                    'index' => 0,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml2-acs.php/pimcore_admin',
                ),
            1 =>
                array (
                    'index' => 1,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:browser-post',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml1-acs.php/pimcore_admin',
                ),
            2 =>
                array (
                    'index' => 2,
                    'Binding' => 'urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Artifact',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml2-acs.php/pimcore_admin',
                ),
            3 =>
                array (
                    'index' => 3,
                    'Binding' => 'urn:oasis:names:tc:SAML:1.0:profiles:artifact-01',
                    'Location' => 'http://ls-bmz-pimcore.loc/sso/module.php/saml/sp/saml1-acs.php/pimcore_admin/artifact',
                ),
        ),
    'certData' => 'MIIDljCCAf4CCQCnFpmAPsOYozANBgkqhkiG9w0BAQsFADANMQswCQYDVQQGEwJERTAeFw0xOTA3MjMwNzUzNTNaFw0yOTA3MjIwNzUzNTNaMA0xCzAJBgNVBAYTAkRFMIIBojANBgkqhkiG9w0BAQEFAAOCAY8AMIIBigKCAYEAr/iz1VUKuGsISutl0FuqNEobsjyukkV0f7T+UZsDOmteQZIL1Og3RY9hRCIbwqF2zyh965YYWnopVwvb9e1xe+tUVq+fXTHhumXw0gpXMBdMzLCtTZTy+vjzJag65BbvYlkZBUbPX6T3+KKqa2jPGSLnarxzExcyWkdFzq8Ofz/IdOTygR8mliNMBSXblcHzl+LXZJDfuk46qJnOJRvie7HoyWkr4Fjeo+hTP1Lg68mhMWFO5AC1DKR7qgc9xc/4Gvl+sA70X6kABYpMvvs0a2kwem2Tc8Tmf4SMQJ2Rgqi5Qbau7yKlZExb77/oU/i2OqER+fqBKclNY1xitMSQRkGISJvXU7QWmSyd1CpK80Xk1+kR/4wYdBSmnXfS4L8Q9qt3Ldg+2XnkL+It186AY5BcAwFi8zAWql2JIYxNP4qnPcY/mJ4/MqAsxWAvX6Y9AJ0oH2xSLpCGfhSxh+twC4ORSwg7+j1qX01ShWOx4cd23ndGnh3TALles8cjJ3MZAgMBAAEwDQYJKoZIhvcNAQELBQADggGBAIRmoTMxofJLP5TDUmBz2e7nj37hY6MwcCAE+lgtxohC3QvY3N9Rnifm+Rg49OpaPRUzOGBAC3wJcbcdN3hTGmgrvRrsDCvm3B1dMnOFHWTna4uWmtxeISvFwVSwPATX1wSb6F10KY7MdpaXnrLfKgLyXTToZccb+9gjFI3KkQwO8VOfgzWR2JYdBi8zyaKh1CFZyaU5FESCj4GOlRFM71i+s0lS/CEe4hhpoiuFpzjWrwFh3VwZzC4gLj/1WtSayBdn0iXQbYc/O0IV7aVpsUoR61EdIriy5VfUThyBu1g5tdUQ2mnhGGQL2JC/DRwKe1Y7o5+NiDYlDoH/k44gBV7HU401CkoJtklkY3glF0FQcjyFOnvJBaWWbkE+BeNKPoK+5KXFJm9Da6dGpAABcoUFPnHEc+c6qBTlZcSuilu1Q6yRDAYxjf/7PZ7CVqS3TgRZoVpiypUHHIWKEIw+O4/2Ccq51DR8ZuJH0jgdNnd6TxD10PK5pz4RYgF/I3VhCQ==',
);
