<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Auth\Source;

use SimpleSAML\Module\core\Auth\UserPassBase;
use SimpleSAML\Module\lifestyle\ConfigHelper;

/**
 * Class LDAP
 *
 * LDAP authentication source.
 *
 * See the ldap-entry in config-templates/authsources.php for information about
 * configuration of this authentication source.
 *
 * This class is based on www/auth/login.php.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Auth\Source
 */
class LDAP extends UserPassBase
{
    /**
     * A LDAP configuration object.
     */
    private $ldapConfig;

    /**
     * Constructor for this authentication source.
     *
     * @param array $info Information about this authentication source.
     * @param array $config Configuration.
     */
    public function __construct($info, $config)
    {
        assert('is_array($info)');
        assert('is_array($config)');

        /* Call the parent constructor first, as required by the interface. */
        parent::__construct($info, $config);

        $this->ldapConfig = new ConfigHelper(
            $config,
            'Authentication source ' . var_export($this->authId, true)
        );
    }


    /**
     * Attempt to log in using the given username and password.
     *
     * @param string $username The username the user wrote.
     * @param string $password The password the user wrote.
     * @param array $sasl_args Associative array of SASL options
     * @param array $searchAttributes List of ldap search attributes
     * @return array  Associative array with the users attributes.
     */
    protected function login($username, $password, array $sasl_args = null, array $searchAttributes = null)
    {
        assert('is_string($username)');
        assert('is_string($password)');

        return $this->ldapConfig->login($username, $password, $sasl_args, $searchAttributes);
    }
}
