<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\UserApplication;

use JMS\Serializer\Annotation as Serializer;
use SimpleSAML\Module\lifestyle\Utils\StringUtils;

/**
 * Class Attribute
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\UserApplication
 */
class Attribute
{
    /**
     * @Serializer\SerializedName("name")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("value")
     * @var string
     */
    private $value;

    /**
     * \SimpleSAML\Module\lifestyle\UserApplication\Attribute constructor.
     * @param string $name
     * @param string $value
     */
    private function __construct($name, $value)
    {
        $this->name = StringUtils::toXmlUtf8($name);
        $this->value = StringUtils::toXmlUtf8($value);
    }

    /**
     * @param string $name
     * @param string $value
     * @return Attribute
     */
    public static function fromString($name, $value)
    {
        return new self($name, $value);
    }
}
