<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\UserApplication;

use JMS\Serializer\Annotation as Serializer;
use SimpleSAML\Module\lifestyle\Utils\StringUtils;

/**
 * Class Role
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\UserApplication
 */
class Role
{
    /**
     * @Serializer\SerializedName("name")
     * @var string
     */
    private $name;

    /**
     * \SimpleSAML\Module\lifestyle\UserApplication\Role constructor.
     * @param string $name
     */
    private function __construct($name)
    {
        $this->name = StringUtils::toXmlUtf8($name);
    }

    /**
     * @param string $name
     * @return Role
     */
    public static function fromString($name)
    {
        return new self($name);
    }
}
