<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Api;

use Doctrine\Common\Annotations\AnnotationRegistry;
use JMS\Serializer\Serializer;
use JMS\Serializer\SerializerBuilder;

/**
 * Class Manager
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Api
 */
class Manager
{
    /**
     * @var array
     */
    private $factory = array();

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Api\Manager constructor.
     */
    public function __construct()
    {
        // Annotation class loader needs this
        AnnotationRegistry::registerLoader('class_exists');
    }

    /**
     * @return Configuration\Manager
     */
    public function configuration()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Configuration\Manager());
    }

    /**
     * @return \SimpleSAML\Module\lifestyle\Webservice\Client\Manager
     */
    public function client()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new \SimpleSAML\Module\lifestyle\Webservice\Client\Manager($this->configuration()->client(), $this->cyphering()->encoder(), $this->cyphering()->decoder(), $this->security()->encoder()));
    }

    /**
     * @return \SimpleSAML\Module\lifestyle\Webservice\Cyphering\Manager
     */
    public function cyphering()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new \SimpleSAML\Module\lifestyle\Webservice\Cyphering\Manager($this->configuration()->cyphering()));
    }

    /**
     * @return \SimpleSAML\Module\lifestyle\Webservice\Handler\Manager
     */
    public function handler()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new \SimpleSAML\Module\lifestyle\Webservice\Handler\Manager($this->client()->request(), $this->modelRequest(), $this->serializer()));
    }

    /**
     * @return \SimpleSAML\Module\lifestyle\Webservice\Security\Manager
     */
    public function security()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new \SimpleSAML\Module\lifestyle\Webservice\Security\Manager($this->configuration()->security()));
    }

    /**
     * @return \SimpleSAML\Module\lifestyle\Webservice\Model\Request\Manager
     */
    public function modelRequest()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new \SimpleSAML\Module\lifestyle\Webservice\Model\Request\Manager());
    }

    /**
     * @return Serializer
     */
    public function serializer()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = SerializerBuilder::create()->build());
    }
}
