<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Security;

use SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\Security;

/**
 * Class Manager
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Security
 */
class Manager
{
    /**
     * @var Security
     */
    private $configuration;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Security\Manager constructor.
     * @param Security $configuration
     */
    public function __construct(Security $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @return MessageDigestPasswordEncoder
     */
    public function encoder()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new MessageDigestPasswordEncoder($this->configuration));
    }
}
