<?php
/**
 * Model factory class
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Api;

use AppBundle\EventListener\Cookie\DatabaseHandler as CookieCacheHandler;
use AppBundle\Handler\UserIdentifierValidate;
use AppBundle\Model\Factory as ModelFactory;
use AppBundle\Model\Type\Factory as TypeFactory;
use Psr\Log\LoggerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface as Container;
use Sso\WebserviceBundle\Response\Builder as ResponseBuilder;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Api manager
 */
class Manager
{

    /**
     * Symfony container
     *
     * @var \Symfony\Component\DependencyInjection\ContainerInterface
     */
    public $container;

    /**
     * Model factory class
     *
     * @var ModelFactory
     */
    protected $modelFactory;

    /**
     * Entity factory class
     *
     * @var TypeFactory
     */
    protected $typeFactory;

    /**
     * Xml response builder
     *
     * @var ResponseBuilder
     */
    protected $responseBuilder;

    /**
     * Constructor
     *
     * @param Container $container
     */
    public function __construct(Container $container)
    {
        $this->container = $container;
    }

    /**
     * The logger
     *
     * @return LoggerInterface
     */
    public function logger()
    {
        return $this->container->get('logger');
    }

    /**
     * Validator
     *
     * @return ValidatorInterface
     */
    public function validator()
    {
        return $this->container->get('validator');
    }

    /**
     * Symfony profiler
     *
     * @return \Symfony\Component\HttpKernel\Profiler\Profiler|null
     */
    public function profiler()
    {
        return $this->container->has('profiler') ? $this->container->get('profiler') : null;
    }

    /**
     * Entity manager
     *
     * @return \Doctrine\ORM\EntityManager
     */
    public function database()
    {
        return $this->container->get('doctrine.orm.entity_manager');
    }

    /**
     * Cookie cache handler
     *
     * @return CookieCacheHandler
     */
    public function cookieCache()
    {
        return $this->container->get(CookieCacheHandler::class);
    }

    /**
     * Model factory class
     *
     * @return ModelFactory
     */
    public function modelFactory()
    {
        return null !== $this->modelFactory ? $this->modelFactory : ($this->modelFactory = new ModelFactory($this));
    }

    /**
     * Entity factory class
     *
     * @return TypeFactory
     */
    public function typeFactory()
    {
        return null !== $this->typeFactory ? $this->typeFactory : ($this->typeFactory = new TypeFactory($this));
    }

    /**
     * Xml Response Builder
     *
     * @return ResponseBuilder
     */
    public function responseBuilder()
    {
        return $this->container->get('sso.webservice.response.builder');
    }

    /**
     * @return UserIdentifierValidate
     */
    public function userIdentifierHandler()
    {
        return $this->container->get(UserIdentifierValidate::class);
    }

    /**
     * Error storage
     *
     * @return \Sso\WebserviceBundle\Error\Storage
     */
    public function errors()
    {
        return $this->container->get('sso.webservice.error.storage');
    }

}
