<?php

namespace AppBundle\Entity;

use Doctrine\ORM\Mapping as ORM;

/**
 * CookieCache
 *
 * @ORM\Table(name="cookie_cache",indexes={@ORM\Index(name="expire_idx", columns={"expire"})})
 * @ORM\Entity
 */
class CookieCache
{

    /**
     * @var string
     *
     * @ORM\Column(name="id", type="string", length=32)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="NONE")
     */
    private $id;

    /**
     * @var string
     *
     * @ORM\Column(name="content", type="blob")
     */
    private $content;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="expire", type="datetime")
     */
    private $expire;

    /**
     * Constructor
     * 
     * @param string $username
     */
    public function __construct($username)
    {
        $this->id = $username;
    }

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set content
     *
     * @param string $content
     * @return CookieCache
     */
    public function setContent($content)
    {
        $this->content = $content;

        return $this;
    }

    /**
     * Get content
     *
     * @return string 
     */
    public function getContent()
    {
        return is_resource($this->content) ? stream_get_contents($this->content, -1, 0) : $this->content;
    }

    /**
     * Set expire
     *
     * @param \DateTime $expire
     * @return Test
     */
    public function setExpire($expire)
    {
        $this->expire = $expire;

        return $this;
    }

    /**
     * Get expire
     *
     * @return \DateTime 
     */
    public function getExpire()
    {
        return $this->expire;
    }

    /**
     * Update expire time
     * 
     * No time. Hard coded.
     */
    public function updateExpire()
    {
        $this->expire = new \DateTime();
        $this->expire->add(new \DateInterval('P01D'));
    }
}
