<?php

/**
 * Respnose factory 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Request;

use AppBundle\Api\Manager as ApiManager;

/**
 * Request factory class
 */
class Factory
{

    /**
     * List of factories
     * 
     * @var array
     */
    protected $factories;

    /**
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return \AppBundle\Model\Request\UserIdentifier\Factory
     */
    public function userIdentifier()
    {
        return $this->getFactory('AppBundle\Model\Request\UserIdentifier\Factory');
    }

    /**
     * Get factory object
     * 
     * @param string $class
     * @return object
     */
    protected function getFactory($class)
    {
        return isset($this->factories[$class]) ? $this->factories[$class] : ($this->factories[$class] = new $class($this->apiM));
    }

}
