<?php
/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

namespace AppBundle\Model\Request\UserIdentifier;

use AppBundle\Api\Manager as ApiManager;

class Factory
{

    /**
     * Api Manager
     * 
     * @var ApiManager
     */
    protected $apiM;

    /**
     * Constructor
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * Get user-identifier factory
     * 
     * @param \SimpleXMLElement $simpleXML
     * @return Get
     */
    public function get(\SimpleXMLElement $simpleXML)
    {
        $model = new Get($this->apiM);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            
        }

        return $model;
    }

    /**
     * Validate user-identifier factory
     * 
     * @param \SimpleXMLElement $simpleXML
     * @return Validate
     */
    public function validate(\SimpleXMLElement $simpleXML)
    {
        $model = new Validate($this->apiM);
        try {
            $model->init($simpleXML);
        } catch (BaseException $exc) {
            
        }

        return $model;
    }

}
