<?php

/**
 * User request
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Request\UserIdentifier;

/**
 * User request get user-identifier
 */
class Get extends Base
{
    /**
     * Init user model
     * 
     * @param \SimpleXMLElement $simpleXML
     */
    public function init(\SimpleXMLElement $simpleXML)
    {
        parent::init($simpleXML);
        $this->setUserModel($this->factoryUser($simpleXML->Key->UserType->children()));
    }

    /**
     * Build user object
     * 
     * @param \DOMElement $xml
     * @return \AppBundle\Entity\User
     */
    protected function factoryUser($xml)
    {
        return $this->apiM->typeFactory()->user($xml, array('UserIdentifier_Get'));
    }

    /**
     * Returns a list of allowed field names in xml
     * 
     * @return string
     */
    protected function _xmlAllowedElements()
    {
        return '<Key required="true">'
                . '<UserType required="true">'
                . '<Username required="true"/>'
                . '<Password required="true"/>'
                . '</UserType>'
                . '</Key>';
    }

}
