<?php

namespace LifeStyle\Tools\SamlBundle\DependencyInjection;

use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/extension.html#cookbook-bundles-extension-config-class}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder('life_style_tools_saml');
        $rootNode = $treeBuilder->getRootNode();
        $rootNode
            ->children()
                ->scalarNode('idp_public_certificate_file')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('idp_single_sign_on_url')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('idp_logout_url')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('idp_request_prefix')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('sp_return_url')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('sp_issuer')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('requested_name_id_format')->isRequired()->cannotBeEmpty()->end()
                ->scalarNode('cookie_path')->isRequired()->cannotBeEmpty()->end()
            ->end()
        ;

        return $treeBuilder;
    }
}
