<?php
/**
 * Cookie file load/save/remove event filter
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace LifeStyle\Tools\SamlBundle\Event;

use LifeStyle\Tools\SamlBundle\Saml\Configuration;
use Symfony\Component\EventDispatcher\Event;

/**
 * Cookie file load/save/remove event filter
 */
class FilterCookieFileEvent extends Event
{
    /**
     * Saml config
     *
     * @var Configuration
     */
    protected $samlConfig;

    /**
     * Cookie filename
     *
     * @var string
     */
    protected $cookieFile;

    /**
     * Constructor
     *
     * @param Configuration $samlConfig SAML configuration
     */
    public function __construct(Configuration $samlConfig)
    {
        $this->samlConfig = $samlConfig;
    }

    /**
     * Get saml configuration
     *
     * @return Configuration
     */
    public function getSamlConfig()
    {
        return $this->samlConfig;
    }

    /**
     * Get cookie filename
     *
     * @return string
     */
    public function getCookieFile()
    {
        return null !== $this->cookieFile ? $this->cookieFile : $this->samlConfig->getCookiePath();
    }

    /**
     * Set cookie filename
     *
     * @param string $filename
     */
    public function setCookieFile($filename)
    {
        $this->cookieFile = (string) $filename;
    }
}
