<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace LifeStyle\Tools\SamlBundle\Saml;

/**
 * Interface SamlControllerInterface
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package LifeStyle\Tools\SamlBundle\Saml
 */
interface SamlControllerInterface
{
    /**
     * Login user
     *
     * @param string $username
     * @param string $password
     * @return bool True on success
     */
    public function login($username, $password);

    /**
     * Logout current user
     * @param string $username
     * @return bool|void
     */
    public function logout($username);

    /**
     * Check current user logged in
     *
     * @param string $username
     * @return bool
     */
    public function check($username);

    /**
     * Get attribute from saml response
     *
     * @param string $name
     * @return mixed
     */
    public function getAttribute($name);

    /**
     * Session lifetime as unix timestamp
     *
     * @return integer|null
     */
    public function getSessionLifetime();

}
