<?php

/**
 * Steps ValidateAction
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Controller\UserIdentifierController;

use JMS\Serializer\Annotation as Serializer;
use Sso\Component\IdentifyServiceBundle\Node\UserKey;
use Sso\Component\IdentifyServiceBundle\Node\Request\Controller\ActionInterface;

/**
 * Steps ValidateAction
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ValidateAction implements ActionInterface
{

    /**
     *
     * @Serializer\Groups({"Request::UserIdentifier::Validate"})
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\Component\IdentifyServiceBundle\Node\UserKey")
     * @var UserKey
     */
    private $userKey;

    /**
     * 
     * @param UserKey $userKey
     * @return ValidateAction
     */
    public function setUserKey(UserKey $userKey)
    {
        $this->userKey = $userKey;

        return $this;
    }

    /**
     * 
     * @return UserKey
     */
    public function getUserKey()
    {
        return $this->userKey;
    }

    /**
     * Get action name
     * 
     * @return string
     */
    public function getName()
    {
        return 'Validate';
    }
}
