<?php

/**
 * Steps Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Credentials;

/**
 * Steps Factory
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Factory
{

    /**
     * Create new UserIdentifierController node
     * 
     * @return \Sso\Component\IdentifyServiceBundle\Node\Request\Credentials\Credentials
     */
    public function credentials()
    {
        return new Credentials();
    }

    /**
     * 
     * @param Credentials $credentials
     * @return ServiceCountry
     */
    public function serviceCountry(Credentials $credentials)
    {
        $serviceCountry = new ServiceCountry();
        $credentials->setServiceCountry($serviceCountry);

        return $serviceCountry;
    }

    /**
     * 
     * @param Credentials $credentials
     * @return ServiceProvider
     */
    public function serviceProvider(Credentials $credentials)
    {
        $serviceProvider = new ServiceProvider();
        $credentials->setServiceProvider($serviceProvider);

        return $serviceProvider;
    }

    /**
     * 
     * @param Credentials $credentials
     * @return ServiceTrigger
     */
    public function serviceTrigger(Credentials $credentials)
    {
        $serviceTrigger = new ServiceTrigger();
        $credentials->setServiceTrigger($serviceTrigger);

        return $serviceTrigger;
    }

}