<?php

/**
 * Steps ServiceCountry
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node\Request\Credentials;

use JMS\Serializer\Annotation as Serializer;

/**
 * Steps ServiceCountry
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class ServiceCountry
{

    /**
     * @Serializer\Groups({"Request::Credentials"})
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("string")
     * @var string
     */
    private $code;

    /**
     * 
     * @param string $code
     * @return ServiceCountry
     */
    public function setCode($code)
    {
        $this->code = (string) $code;

        return $this;
    }

}