<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Tools\AWSBundle\Tests\Controller;

use Symfony\Bundle\FrameworkBundle\Test\WebTestCase;

/**
 * Class HealthCheckControllerTest
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\Tools\AWSBundle\Tests\Controller
 */
class HealthCheckControllerTest extends WebTestCase
{
    public function testStatusAction()
    {
        $client = static::createClient();

        $client->request('GET', '/status', [], [], ['HTTP_USER_AGENT' => 'ELB-HealthChecker']);

        $this->assertEquals(200, $client->getResponse()->getStatusCode());
        $this->assertEquals('OK', $client->getResponse()->getContent());
    }

    public function testDefaultAction()
    {
        $client = static::createClient();

        $client->request('GET', '/', [], [], ['HTTP_USER_AGENT' => 'ELB-HealthChecker']);

        $this->assertEquals(200, $client->getResponse()->getStatusCode());
        $this->assertEquals('OK', $client->getResponse()->getContent());
    }

    public function testFirewall()
    {
        $client = static::createClient();

        $client->request('GET', '/');

        $this->assertEquals(200, $client->getResponse()->getStatusCode());
        $this->assertNotEquals('OK', $client->getResponse()->getContent());
    }
}
