<?php

$config = array(
    // This is a authentication source which handles admin authentication.
    'admin' => array(
        // The default is to use core:AdminPassword, but it can be replaced with
        // any authentication source.

        'lifestyle:AdminPassword',
    ),

    'user-webservice-select' => array(
        'lifestyle:WebserviceSelect',
        'authsources' => array(
            'user-webservice',
            'user-local',
        ),
    ),
    'user-webservice' => array(
        'lifestyle:Webservice',
    ),
    'user-local' => array(
        'exampleauth:UserPass',
        'lifestyle:pfad#1' => array(
            'username' => array('info@life-style.de'),
            'name' => array('Life-Style'),
            'email' => array('info@life-style.de'),
            'groups' => array('Admin', 'Root'),
            'mfaEnabled' => array('1'),
        ),
    ),
    'berlitz-idp-azure' => [
        'saml:SP',

        // The entity ID of this SP.
        // Can be NULL/unset, in which case an entity ID is generated based on the metadata URL.
        'entityID' => null,

        // The entity ID of the IdP this SP should contact.
        // Can be NULL/unset, in which case the user will be shown a list of available IdPs.
        'idp' => 'http://berlitz-idp-azure.loc/saml2/idp/metadata.php',

        // The URL to the discovery service.
        // Can be NULL/unset, in which case a builtin discovery service will be used.
        'discoURL' => null,

        /*
         * The attributes parameter must contain an array of desired attributes by the SP.
         * The attributes can be expressed as an array of names or as an associative array
         * in the form of 'friendlyName' => 'name'. This feature requires 'name' to be set.
         * The metadata will then be created as follows:
         * <md:RequestedAttribute FriendlyName="friendlyName" Name="name" />
         */
        /*
        'name' => [
            'en' => 'A service',
            'no' => 'En tjeneste',
        ],

        'attributes' => [
            'attrname' => 'urn:oid:x.x.x.x',
        ],
        'attributes.required' => [
            'urn:oid:x.x.x.x',
        ],
        */
    ],
);
