<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Error;

use SimpleSAML\Error\ErrorCodes;
use SimpleSAML\Error\Error as BaseError;
use SimpleSAML\Locale\Translate;

/**
 * Class Error
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Error
 */
class Error extends BaseError
{
    /**
     * @var string
     */
    private $errorCode;

    /**
     * @inheritDoc
     */
    public function __construct($errorCode, \Exception $cause = null, $httpCode = null)
    {
        $this->errorCode = $errorCode;
        $errorTitles = ErrorCodes::defaultGetAllErrorCodeTitles();
        parent::__construct(isset($errorTitles[$errorCode]) ? $errorCode : 'NOTSET', $cause, $httpCode);
    }

    /**
     * @inheritDoc
     */
    public function getErrorCode()
    {
        return $this->errorCode;
    }

    /**
     * @inheritDoc
     */
    public function getDictTitle()
    {
        return Translate::noop('{errors:title_' . $this->errorCode . '}');
    }

    /**
     * @inheritDoc
     */
    public function getDictDescr()
    {
        return Translate::noop('{errors:descr_' . $this->errorCode . '}');
    }
}
