<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Twig;

use SimpleSAML\XHTML\TemplateControllerInterface;
use Twig\Environment;

/**
 * Class LifestyleThemeController
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package Twig
 */
class LifestyleThemeController implements TemplateControllerInterface
{
    /**
     * Implement to modify the twig environment after its initialization (e.g. add filters or extensions).
     *
     * @param \Twig\Environment $twig The current twig environment.
     *
     * @return void
     */
    public function setUpTwig(Environment &$twig)
    {
        // TODO: Implement setUpTwig() method.
    }

    /**
     * Implement to add, delete or modify the data passed to the template.
     *
     * This method will be called right before displaying the template.
     *
     * @param array $data The current data used by the template.
     *
     * @return void
     */
    public function display(&$data)
    {
        $this->addErrorCode($data);
    }

    /**
     * Add custom error codes
     * @param array $data
     */
    private function addErrorCode(&$data)
    {
        if (isset($data['errorcode'])) {
            $errorCode = $data['errorcode'];
            if (!isset($data['errorcodes']['title'][$errorCode])) {
                $data['errorcodes']['title'][$errorCode] = '{errors:title_' . $errorCode . '}';
            }
            if (!isset($data['errorcodes']['descr'][$errorCode])) {
                $data['errorcodes']['descr'][$errorCode] = '{errors:descr_' . $errorCode . '}';
            }
        }
    }
}
