<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\UserApplication;

use JMS\Serializer\Annotation as Serializer;
use JMS\Serializer\SerializerBuilder;
use SimpleSAML\Module\lifestyle\Utils\StringUtils;

/**
 * Class Application
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\UserApplication
 */
class Application
{
    /**
     * @Serializer\SerializedName("name")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("attributes")
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\SerializedName("roles")
     * @var Role[]
     */
    private $roles;

    /**
     * Application constructor.
     * @param string $name
     */
    private function __construct($name)
    {
        $this->name = StringUtils::toXmlUtf8($name);
        $this->attributes = array();
        $this->roles = array();
    }

    /**
     * @param Attribute $attribute
     * @return Application
     */
    public function addAttribute(Attribute $attribute)
    {
        $this->attributes[] = $attribute;
        return $this;
    }

    /**
     * @param Role $role
     * @return Application
     */
    public function addRole(Role $role)
    {
        $this->roles[] = $role;
        return $this;
    }

    /**
     * @param string $name
     * @return Application
     */
    public static function fromString($name)
    {
        return new self($name);
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function toString()
    {
        return SerializerBuilder::create()->build()->serialize($this, 'json');
    }
}
