<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Utils;

use SimpleSAML\Logger;
use SimpleSAML\Session;

/**
 * Class Security
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Utils
 */
class Security
{
    /**
     * @param string $username
     * @param array $formData
     * @return bool
     */
    public static function validate($username, array $formData)
    {
        if (!isset($formData["firstname"]) || static::stringRewinder($username) !== $formData['firstname']) {
            Logger::info('Invalid captcha: field firstname failed.');
            return false;
        }

        if (!isset($formData["middlename"]) || 0 !== strlen($formData['middlename'])) {
            Logger::info('Invalid captcha: field middlename failed.');
            return false;
        }

        if (!isset($formData["lastname"]) || static::stringNiner($username) !== $formData['lastname']) {
            Logger::info('Invalid captcha: field lastname failed.');
            return false;
        }

        try {
            $session = Session::getSessionFromRequest();
        } catch (\Exception $e) {
            Logger::info('Invalid captcha: session could not be initialized.');
            return false;
        }

        if (!isset($formData["comments"]) || $session->getSessionId() !== $formData['comments']) {
            Logger::info('Invalid captcha: field comments failed.');
            return false;
        }

        return true;
    }

    /**
     * @param string $username
     * @return string
     */
    public static function stringNiner($username)
    {
        return '4' . join('', array_map(function ($vvv) {
                return $vvv . '2';
            }, static::str_split_unicode($username)));
    }

    /**
     * A-N-N-A
     * @param string $username
     * @return string
     */
    public static function stringRewinder($username)
    {
        return join('', array_reverse(static::str_split_unicode($username, 1)));
    }

    /**
     * @param string $str
     * @param int $chars
     * @return array|array[]|false|string[]
     */
    public static function str_split_unicode($str, $chars = 0)
    {
        if ($chars > 0) {
            $ret = array();
            $len = mb_strlen($str, "UTF-8");
            for ($idx = 0; $idx < $len; $idx += $chars) {
                $ret[] = mb_substr($str, $idx, $chars, "UTF-8");
            }
            return $ret;
        }
        return preg_split("//u", $str, -1, PREG_SPLIT_NO_EMPTY);
    }
}
