<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Utils;

/**
 * Class StringUtils
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Utils
 */
class StringUtils
{
    /**
     * Split a string by string, trim each element
     *
     * @param string $delemiter The boundary string
     * @param string $value The input string
     * @return array
     */
    static public function trimsplit($delemiter, $value)
    {
        $items = array();
        foreach (explode($delemiter, $value) as $item) {
            $items[] = trim($item);
        }
        return $items;
    }

    /**
     * Remove none utf-8 characters from value for XML export
     *
     * @param string $value The input string
     * @return string
     */
    static public function toXmlUtf8($value)
    {
        return preg_replace('/[^\x{0009}\x{000a}\x{000d}\x{0020}-\x{D7FF}\x{E000}-\x{FFFD}]+/u', ' ', $value);
    }
}
