<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Api\Configuration;

use SimpleSAML\Configuration;
use SimpleSAML\Module\lifestyle\Error\ConfigurationException;

/**
 * Class Client
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Api\Configuration
 */
class Client
{
    /**
     * @var string
     */
    private $baseUri;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $password;

    /**
     * @var string
     */
    private $salt;

    /**
     * @var string
     */
    private $serviceToken;

    /**
     * loaded from configuration
     * @var integer
     */
    private $openSslCipherIndex = 0;

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\Client constructor.
     * @param Configuration $configuration
     * @throws ConfigurationException
     */
    public function __construct(Configuration $configuration)
    {
        $config = $configuration->getArray('webservice.client', array());

        /* Make sure that all required configuration params are present. */
        foreach (array('baseUri', 'username', 'password', 'salt', 'serviceToken') as $param) {
            if (!array_key_exists($param, $config)) {
                throw new ConfigurationException(sprintf('Missing required configuration webservice.client[%s] for webservice client.', $param));
            }

            if (!is_string($config[$param])) {
                throw new ConfigurationException(sprintf('Expected configuration paramter webservice.client[%s] for webservice client is not a string. Instead it was: %s', $param, var_export($config[$param], true)));
            }

            $this->$param = $config[$param];
        }

        $config = $configuration->getArray('webservice.cyphering', array());
        $this->openSslCipherIndex = isset($config['openSslCipherIndex']) ? (int)$config['openSslCipherIndex'] : 0;
    }

    /**
     * @return string
     */
    public function getBaseUri()
    {
        return $this->baseUri;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * @return string
     */
    public function getSalt()
    {
        return $this->salt;
    }

    /**
     * @return string
     */
    public function getServiceToken()
    {
        return $this->serviceToken;
    }

    /**
     * @return int
     */
    public function getOpenSslCipherIndex(): int
    {
        return $this->openSslCipherIndex;
    }
}
