<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Api\Configuration;

use SimpleSAML\Configuration;
use SimpleSAML\Module\lifestyle\Error\ConfigurationException;

/**
 * Class Security
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Api\Configuration
 */
class Security
{
    /**
     * @var string
     */
    private $algorithm = 'sha512';

    /**
     * @var boolean
     */
    private $encodeHashAsBase64 = true;

    /**
     * @var int
     */
    private $iterations = 5000;

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\User constructor.
     * @param Configuration $configuration
     * @throws ConfigurationException
     */
    public function __construct(Configuration $configuration)
    {
        $config = $configuration->getArray('webservice.security', array());

        if (array_key_exists('algorithm', $config)) {
            if (!is_string($config['algorithm'])) {
                throw new ConfigurationException(sprintf('Expected configuration paramter webservice.security[algorithm] for webservice security is not a string. Instead it was: %s', var_export($config['algorithm'], true)));
            }
            $this->algorithm = $config['algorithm'];
        }
        if (array_key_exists('encodeHashAsBase64', $config)) {
            if (!is_bool($config['encodeHashAsBase64'])) {
                throw new ConfigurationException(sprintf('Expected configuration paramter webservice.security[encodeHashAsBase64] for webservice security is not a boolean. Instead it was: %s', var_export($config['encodeHashAsBase64'], true)));
            }
            $this->encodeHashAsBase64 = $config['encodeHashAsBase64'];
        }
        if (array_key_exists('iterations', $config)) {
            if (!is_int($config['iterations'])) {
                throw new ConfigurationException(sprintf('Expected configuration paramter webservice.security[iterations] for webservice security is not a integer. Instead it was: %s', var_export($config['iterations'], true)));
            }
            $this->iterations = $config['iterations'];
        }
    }

    /**
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->algorithm;
    }

    /**
     * @return boolean
     */
    public function isEncodeHashAsBase64()
    {
        return $this->encodeHashAsBase64;
    }

    /**
     * @return int
     */
    public function getIterations()
    {
        return $this->iterations;
    }
}
