<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Client;

use Psr\Http\Message\RequestInterface;
use GuzzleHttp\Client;
use GuzzleHttp\HandlerStack;
use SimpleSAML\Module\lifestyle\Webservice\Api\Configuration\Client as ClientConfiguration;

/**
 * Class ClientFactory
 *
 * @copyright  2020 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Client
 */
class ClientFactory
{
    /**
     * @var ClientConfiguration
     */
    private $clientConfiguration;

    /**
     * ClientFactory constructor.
     * @param ClientConfiguration $clientConfiguration
     */
    public function __construct(ClientConfiguration $clientConfiguration)
    {
        $this->clientConfiguration = $clientConfiguration;
    }

    /**
     * @return Client
     */
    public function create(): Client
    {
        $stack = HandlerStack::create();
        $stack->push($this->addHeader('X-SSL-ENCRYPT-IDX', (string)$this->clientConfiguration->getOpenSslCipherIndex()));

        return new Client([
            'base_uri' => $this->clientConfiguration->getBaseUri(),
            'handler' => $stack,
        ]);
    }

    /**
     * @param string $header
     * @param string $value
     * @return \Closure
     */
    private function addHeader($header, $value)
    {
        return function (callable $handler) use ($header, $value) {
            return function (
                RequestInterface $request,
                array $options
            ) use ($handler, $header, $value) {
                $request = $request->withHeader($header, $value);
                return $handler($request, $options);
            };
        };
    }
}
