<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Handler;

use JMS\Serializer\Serializer;
use SimpleSAML\Module\lifestyle\Webservice\Client\Request;
use SimpleSAML\Module\lifestyle\Webservice\Handler\User\PostApplicationAttributes\Handler;
use SimpleSAML\Module\lifestyle\Webservice\Handler\User\PostShow\Handler as PostShowHandler;

/**
 * Class Manager
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Handler
 */
class Manager
{
    /**
     * @var Request
     */
    private $request;

    /**
     * @var \SimpleSAML\Module\lifestyle\Webservice\Model\Request\Manager
     */
    private $requestModel;

    /**
     * @var Serializer
     */
    private $serializer;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Handler\Manager constructor.
     * @param Request $request
     * @param \SimpleSAML\Module\lifestyle\Webservice\Model\Request\Manager $requestModel
     * @param Serializer $serializer
     */
    public function __construct(
        Request $request,
        \SimpleSAML\Module\lifestyle\Webservice\Model\Request\Manager $requestModel,
        Serializer $serializer
    ) {
        $this->request = $request;
        $this->requestModel = $requestModel;
        $this->serializer = $serializer;
    }

    /**
     * @return IdP\PostLogin\Handler
     */
    public function postLogin()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new IdP\PostLogin\Handler($this->request, $this->requestModel->idP(), $this->serializer));
    }

    /**
     * @return IdP\PostLoginFailed\Handler
     */
    public function postLoginFailed()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new IdP\PostLoginFailed\Handler($this->request, $this->requestModel->idP(), $this->serializer));
    }

    /**
     * @return IdP\PostLoginSuccess\Handler
     */
    public function postLoginSuccess()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new IdP\PostLoginSuccess\Handler($this->request, $this->requestModel->idP(), $this->serializer));
    }

    /**
     * @return Mfa\PostMfaValidate\Handler
     */
    public function postMfaValidate()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Mfa\PostMfaValidate\Handler($this->request, $this->requestModel->mfa(), $this->serializer));
    }

    /**
     * @return Handler
     */
    public function postUser()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new Handler($this->request, $this->requestModel->user(), $this->serializer));
    }

    /**
     * @return PostShowHandler
     */
    public function postShowUser()
    {
        return isset($this->factory[__FUNCTION__]) ? $this->factory[__FUNCTION__] : ($this->factory[__FUNCTION__] = new PostShowHandler($this->request, $this->requestModel->user(), $this->serializer));
    }
}
