<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes
 * @Serializer\XmlRoot("applicationTypes")
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * \SimpleSAML\Module\lifestyle\Webservice\Model\Request\User\PostApplicationAttributes\ApplicationType constructor.
     * @param string $name
     */
    public function __construct($name)
    {
        $this->name = $name;
    }
}
