<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes
 */
class ApplicationType
{
    /**
     * @Serializer\SerializedName("name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("attributes")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes\Attribute>")
     * @Serializer\XmlList(inline = false, entry = "attribute")
     *
     * @var Attribute[]
     */
    private $attributes;

    /**
     * @Serializer\SerializedName("roles")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes\Role>")
     * @Serializer\XmlList(inline = false, entry = "role")
     * @var Role[]
     */
    private $roles;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return Attribute[]
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * @return Role[]
     */
    public function getRoles()
    {
        return $this->roles;
    }

    /**
     * @Serializer\PostDeserialize()
     */
    public function postDeserialize()
    {
        if (!is_array($this->attributes)) {
            $this->attributes = array();
        }
        if (!is_array($this->roles)) {
            $this->roles = array();
        }
    }
}
