<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes;

use JMS\Serializer\Annotation as Serializer;
use SimpleSAML\Module\lifestyle\Webservice\Model\Response\Error;

/**
 * Class Response
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes
 * @Serializer\XmlRoot("response")
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("applications")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostApplicationAttributes\ApplicationType>")
     *
     * @var ApplicationType[]
     */
    private $applications;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Response\Error>")
     * @Serializer\XmlList(entry="error")
     *
     * @var Error[]
     */
    private $errors;

    /**
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @return string
     */
    public function getTrackId()
    {
        return $this->trackId;
    }

    /**
     * @return string
     */
    public function getDurationSeconds()
    {
        return $this->durationSeconds;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @return ApplicationType[]
     */
    public function getApplications()
    {
        return is_array($this->applications) ? $this->applications : [];
    }

    /**
     * @return Error[]|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
}
