<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace SimpleSAML\Module\lifestyle\Webservice\Model\Response\User\PostShow;

use JMS\Serializer\Annotation as Serializer;
use SimpleSAML\Module\lifestyle\Webservice\Model\Response\Errors;

/**
 * Class Response
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 * @package PostShow
 */
class Response
{
    /**
     * @Serializer\SerializedName("status")
     * @Serializer\Type("integer")
     *
     * @var integer|null
     */
    private $status;

    /**
     * @Serializer\SerializedName("message")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $message;

    /**
     * @Serializer\SerializedName("trackId")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $trackId;

    /**
     * @Serializer\SerializedName("durationSeconds")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $durationSeconds;

    /**
     * @Serializer\SerializedName("userIdentifier")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userIdentifier;

    /**
     * @Serializer\SerializedName("username")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $username;

    /**
     * @Serializer\SerializedName("userGuid")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userGuid;

    /**
     * @Serializer\SerializedName("active")
     * @Serializer\Type("boolean")
     *
     * @var boolean|null
     */
    private $active;

    /**
     * @Serializer\SerializedName("userAuthId")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userAuthId;

    /**
     * @Serializer\SerializedName("userLdapSearchAttributes")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLdapSearchAttributes;

    /**
     * @Serializer\SerializedName("userLdapSearchValue")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLdapSearchValue;

    /**
     * @Serializer\SerializedName("userEmail")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userEmail;

    /**
     * @Serializer\SerializedName("userFirstname")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userFirstname;

    /**
     * @Serializer\SerializedName("userLastname")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $userLastname;

    /**
     * @Serializer\SerializedName("mfaEnabled")
     * @Serializer\Type("boolean")
     *
     * @var boolean|null
     */
    private $mfaEnabled = false;

    /**
     * @Serializer\SerializedName("mfaQrCode")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $mfaQrCode;

    /**
     * @Serializer\SerializedName("forcePasswordReset")
     * @Serializer\Type("boolean")
     *
     * @var boolean|null
     */
    private $forcePasswordReset = false;

    /**
     * @Serializer\SerializedName("resetPasswordToken")
     * @Serializer\Type("string")
     *
     * @var string|null
     */
    private $resetPasswordToken;

    /**
     * @Serializer\SerializedName("resetPasswordTokenExpire")
     * @Serializer\Type("DateTime")
     *
     * @var \DateTime|null
     */
    private $resetPasswordTokenExpire;

    /**
     * @Serializer\SerializedName("lastLogin")
     * @Serializer\Type("DateTime")
     *
     * @var string|null
     */
    private $lastLogin;

    /**
     * @Serializer\SerializedName("loginFails")
     * @Serializer\Type("integer")
     *
     * @var integer|null
     */
    private $loginFails;

    /**
     * @Serializer\SerializedName("errors")
     * @Serializer\Type("array<SimpleSAML\Module\lifestyle\Webservice\Model\Response\Error>")
     *
     * @var Errors|null
     */
    private $errors;

    /**
     * @return int|null
     */
    public function getStatus(): ?int
    {
        return $this->status;
    }

    /**
     * @return string|null
     */
    public function getMessage(): ?string
    {
        return $this->message;
    }

    /**
     * @return string|null
     */
    public function getTrackId(): ?string
    {
        return $this->trackId;
    }

    /**
     * @return string|null
     */
    public function getDurationSeconds(): ?string
    {
        return $this->durationSeconds;
    }

    /**
     * @return string|null
     */
    public function getUserIdentifier(): ?string
    {
        return $this->userIdentifier;
    }

    /**
     * @return string|null
     */
    public function getUsername(): ?string
    {
        return $this->username;
    }

    /**
     * @return string|null
     */
    public function getUserGuid(): ?string
    {
        return $this->userGuid;
    }

    /**
     * @return bool|null
     */
    public function getActive(): ?bool
    {
        return $this->active;
    }

    /**
     * @return string|null
     */
    public function getUserAuthId(): ?string
    {
        return $this->userAuthId;
    }

    /**
     * @return string|null
     */
    public function getUserLdapSearchAttributes(): ?string
    {
        return $this->userLdapSearchAttributes;
    }

    /**
     * @return string|null
     */
    public function getUserLdapSearchValue(): ?string
    {
        return $this->userLdapSearchValue;
    }

    /**
     * @return string|null
     */
    public function getUserEmail(): ?string
    {
        return $this->userEmail;
    }

    /**
     * @return string|null
     */
    public function getUserFirstname(): ?string
    {
        return $this->userFirstname;
    }

    /**
     * @return string|null
     */
    public function getUserLastname(): ?string
    {
        return $this->userLastname;
    }

    /**
     * @return bool|null
     */
    public function getMfaEnabled(): ?bool
    {
        return $this->mfaEnabled;
    }

    /**
     * @return string|null
     */
    public function getMfaQrCode(): ?string
    {
        return $this->mfaQrCode;
    }

    /**
     * @return bool|null
     */
    public function getForcePasswordReset(): ?bool
    {
        return $this->forcePasswordReset;
    }

    /**
     * @return string|null
     */
    public function getResetPasswordToken(): ?string
    {
        return $this->resetPasswordToken;
    }

    /**
     * @return \DateTime|null
     */
    public function getResetPasswordTokenExpire(): ?\DateTime
    {
        return $this->resetPasswordTokenExpire;
    }

    /**
     * @return string|null
     */
    public function getLastLogin(): ?string
    {
        return $this->lastLogin;
    }

    /**
     * @return int|null
     */
    public function getLoginFails(): ?int
    {
        return $this->loginFails;
    }

    /**
     * @return Errors|null
     */
    public function getErrors(): ?Errors
    {
        return $this->errors;
    }
}
