<?php

$themes = [
    'other-theme'=> '#^https?://[^\/]*other-page#',
];

foreach ($themes as $theme => $searchPattern) {
    // Used for normal login
    if (isset($this->data['SPMetadata']['metadata-index']) &&
        preg_match($searchPattern, $this->data['SPMetadata']['metadata-index'])
    ) {
        return $theme;
    }

    // Used if redirected from mfa dialogue
    if ($this->data['stateparams']['AuthState']) {
        parse_str(parse_url($this->data['stateparams']['AuthState'], PHP_URL_QUERY), $query);
        if (isset($query['spentityid']) && preg_match($searchPattern, $query['spentityid'])
        ) {
            return $theme;
        }
    }
}

// Default theme
return 'lifestyle';
