<?php

use SimpleSAML\Configuration;
use SimpleSAML\Module\lifestyle\Utils\UrlBuilder;
use SimpleSAML\Session;

$templatePathPrefix = 'lifestyle';

$session = Session::getSessionFromRequest();
$urlBuilder = new UrlBuilder(
    Configuration::getInstance(),
    $_REQUEST['AuthState'],
    $this->getLanguage()
);

$this->data['header'] = $this->t('{login:user_pass_header}');

if (0 === strlen($this->data['username']) && isset($_COOKIE['user'])) {
    $this->data['username'] = (string)$_COOKIE['user'];
}

$this->includeAtTemplateBase($templatePathPrefix . ':includes/header.php');
?>
    <div class="container" role="main">

        <?php $this->includeAtTemplateBase($templatePathPrefix . ':includes/deprecatedBrowsers.php'); ?>

        <div class="row center">
            <div class="col-xs-12 hidden-xs">
                <h1><?php echo $this->t('{lifestyle:login:header_headline}'); ?></h1>
                <p><?php echo $this->t('{lifestyle:login:header_text}'); ?></p>
            </div>
            <div class="col-xs-12 visible-xs">
                <h1><?php echo $this->t('{lifestyle:login:header_headline_mobile}'); ?></h1>
            </div>
        </div>

        <?php if ($this->data['errorcode'] !== NULL): ?>
            <div class="row center">
                <div class="col-xs-12">
                    <div class="alert alert-danger">
                        <?php echo htmlspecialchars($this->t('{errors:title_' . $this->data['errorcode'] . '}', $this->data['errorparams'])); ?>
                        <br/>
                        <?php echo htmlspecialchars($this->t('{errors:descr_' . $this->data['errorcode'] . '}', $this->data['errorparams'])); ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row center">
            <div class="col-xs-12">
                <form method="post" action="?" id="login" class="form-decorators-js form-login-js">
                <?php if (!isset($this->data['hideUsername'])): ?>
                    <div class="form-group <?php if (strlen($this->data['username'])): ?>form-group-focus<?php endif; ?>">
                        <label class="labelForm <?php if (strlen($this->data['username'])): ?>labelFocus<?php endif; ?>" for="username"><?php echo $this->t('{lifestyle:login:username}'); ?></label>
                        <input tabindex="1" type="text" value="<?php echo htmlspecialchars($this->data['username']); ?>" class="form-control" name="username" id="username" >
                        <div class="error username"></div>
                    </div>
                    <div class="form-group">
                        <label class="labelForm" for="password"><?php echo $this->t('{lifestyle:login:password}'); ?></label>
                        <input tabindex="2" type="password" value="" class="form-control" name="password" id="password" />
                        <div class="error password"></div>
                    </div>
                <?php elseif ($this->data['hideUsername']): ?>
                    <input type="hidden" value="<?php echo htmlspecialchars($this->data['username']); ?>" name="username" id="username">
                    <div class="form-group">
                        <label class="labelForm" for="password"><?php echo $this->t('{lifestyle:login:password}'); ?></label>
                        <input tabindex="2" type="password" value="" class="form-control" name="password" id="password" />
                        <div class="error password"></div>
                    </div>
                <?php else: ?>
                    <div class="form-group <?php if (strlen($this->data['username'])): ?>form-group-focus<?php endif; ?>">
                        <label class="labelForm <?php if (strlen($this->data['username'])): ?>labelFocus<?php endif; ?>" for="username"><?php echo $this->t('{lifestyle:login:username}'); ?></label>
                        <input tabindex="1" type="text" value="<?php echo htmlspecialchars($this->data['username']); ?>" class="form-control" name="username" id="username" >
                        <div class="error username"></div>
                    </div>
                <?php endif; ?>
                    <div class="form-group block-margin">
                        <label class="labelForm" for="firstname">Firstname</label>
                        <input type="text" value="" class="form-control" name="firstname" id="firstname"/>
                    </div>
                    <div class="form-group block-margin">
                        <label class="labelForm" for="middlename">Middlename</label>
                        <input type="text" value="" class="form-control" name="middlename" id="middlename"/>
                    </div>
                    <div class="form-group block-margin">
                        <label class="labelForm" for="lastname">Lastname</label>
                        <input type="text" value="" class="form-control" name="lastname" id="lastname"/>
                    </div>
                    <div class="form-group block-margin">
                        <label class="labelForm" for="comments">Comments</label>
                        <input type="text" value="<?php echo $session->getSessionId(); ?>" class="form-control" name="comments" id="comments" />
                    </div>
                    <div class="text-center">
                        <?php if (!isset($this->data['hideUsername'])): ?>
                            <button tabindex="3" class="btn btn-submit btn-submit-js w100" disabled="disabled" onclick="$('#btn-submit-hidden-js').click();return false;">
                                <span class="icons icon-lock" aria-hidden="true"></span>
                                <p><?php echo $this->t('{lifestyle:login:submit}'); ?></p>
                            </button>
                        <?php elseif ($this->data['hideUsername']): ?>
                            <div class="row">
                                <div class="col-xs-3">
                                    <a tabindex="4" class="btn btn-submit btn-submit-js w100" href="<?php echo $this->data['urlBack'] ?>">
                                        <span class="icons icon-arrow-previous" aria-hidden="true"></span>
                                    </a>
                                </div>
                                <div class="col-xs-9">
                                    <button tabindex="3" class="btn btn-submit btn-submit-js w100" disabled="disabled" onclick="$('#btn-submit-hidden-js').click();return false;">
                                        <span class="icons icon-lock" aria-hidden="true"></span>
                                        <p><?php echo $this->t('{lifestyle:login:submit}'); ?></p>
                                    </button>
                                </div>
                            </div>
                        <?php else: ?>
                            <button tabindex="3" class="btn btn-submit btn-submit-js w100" disabled="disabled" onclick="$('#btn-submit-hidden-js').click();return false;">
                                <span class="icons icon-lock" aria-hidden="true"></span>
                                <p><?php echo $this->t('{lifestyle:login:next}'); ?></p>
                            </button>
                        <?php endif; ?>
                        <button type="submit" id="btn-submit-hidden-js" class="hidden">not-empty</button>
                    </div>
                    <p class="visible-xs"><?php echo $this->t('{lifestyle:login:header_text}'); ?></p>
                    <a href="<?php echo $urlBuilder->getPasswordForgottenUrl(); ?>"><?php echo $this->t('{lifestyle:login:password_forgotten_headline}'); ?></a>
                    <?php if ($session->getData('string', 'viewRegisterLink')): ?>
                        <a href="<?php echo $this->t('{lifestyle:login:register_url}'); ?>"><?php echo $this->t('{lifestyle:login:register_link_text}'); ?></a>
                    <?php endif; ?>
                    <a href="<?php echo $urlBuilder->getPrivacyUrl(); ?>"><?php echo $this->t('{lifestyle:login:footer_privacy_link}'); ?></a>
                    <?php
                    foreach ($this->data['stateparams'] as $name => $value) {
                        echo('<input type="hidden" name="' . htmlspecialchars($name) . '" value="' . htmlspecialchars($value) . '" />');
                    }
                    ?>
                </form>
            </div>
        </div>

    </div>

    <script>
        (function () {
            var init = function () {

            if (typeof $ === "undefined") {
                    window.setTimeout(init, 250);
                    return;
                }

                window.loginForm = $('#login')
                    .bootstrapValidator({
                        submitButtons: 'button[type="submit"]',
                        feedbackIcons: {
                            valid: 'icons icon-check-big',
                            invalid: 'icons icon-warning',
                            validating: 'icons icon-refresh'
                        },
                        fields: {
                        <?php if (!isset($this->data['hideUsername'])): ?>
                            username: {
                                container: '.error.username',
                                validators: {
                                    notEmpty: {
                                        message: '<?php echo $this->t('{lifestyle:login:emailNotEmpty}'); ?>'
                                    }
                                }
                            },
                            password: {
                                container: '.error.password',
                                validators: {
                                    notEmpty: {
                                        message: '<?php echo $this->t('{lifestyle:login:passwordNotEmpty}'); ?>'
                                    }
                                }
                            }
                        <?php elseif ($this->data['hideUsername']): ?>
                            password: {
                                container: '.error.password',
                                validators: {
                                    notEmpty: {
                                        message: '<?php echo $this->t('{lifestyle:login:passwordNotEmpty}'); ?>'
                                    }
                                }
                            }
                        <?php else: ?>
                            username: {
                                container: '.error.username',
                                validators: {
                                    notEmpty: {
                                        message: '<?php echo $this->t('{lifestyle:login:emailNotEmpty}'); ?>'
                                    }
                                }
                            }
                        <?php endif; ?>
                    }
                });
            };

            init();
        })();
    </script>

    <!-- End Content -->
<?php
$this->includeAtTemplateBase($templatePathPrefix . ':includes/footer.php');
