<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Routing\Annotation\Route;

/**
 * Class LogController
 * @package AppBundle\Controller
 */
class LogController extends Controller
{
    /**
     * @Route("/logs")
     * @return JsonResponse
     * @throws \Doctrine\DBAL\DBALException
     */
    public function getLogs(Request $request)
    {
        $authToken = getenv('LOGS_AUTH_TOKEN');
        if (empty($authToken)) {
            throw $this->createAccessDeniedException('Invalid auth token! Configuration invalid: missing LOGS_AUTH_TOKEN.');
        }
        if ($request->headers->get('X-Auth-Token') !== $authToken) {
            throw $this->createAccessDeniedException('Invalid auth token!');
        }

        $limit = (int)$request->query->get('limit', 100);
        $offset = (int)$request->query->get('offset', 0);

        /** @var \Doctrine\DBAL\Connection $connection */
        $connection = $this->getDoctrine()->getConnection();
        $statement = $connection->prepare('SELECT * FROM log_user_identifier LIMIT ' . $offset . ',' . $limit);
        $statement->execute();
        return new JsonResponse($statement->fetchAll());
    }
}
