<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace AppBundle\Handler;

use AppBundle\Database\Session as Database;
use AppBundle\Entity\Session as SessionEntity;
use Psr\Log\LoggerInterface;

class UserIdentifierValidate
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Database
     */
    private $database;

    /**
     * UserIdentifierValidate constructor.
     * @param LoggerInterface $logger
     * @param Database $database
     */
    public function __construct(LoggerInterface $logger, Database $database)
    {
        $this->logger = $logger;
        $this->database = $database;
    }

    /**
     * @param string $userIdentifier
     * @param string|bool $username
     * @return SessionEntity|null
     */
    public function validate($userIdentifier, $username = false)
    {
        $rows = $this->database->findByUserIdentifier($userIdentifier);

        $usernames = false;
        if (0 < count($rows)) {
            $usernames = join(', ', array_map(function (SessionEntity $session) {
                return $session->getUsername();
            }, $rows));
        } else {
            $logRows = $this->database->findByUserIdentifier($userIdentifier, new \DateTime('yesterday'));
            if (0 < count($logRows)) {
                /** @var SessionEntity $logRow */
                $logRow = reset($logRows);
                $this->logger->error(sprintf(
                    'Could not find user identifier (%s) in session table! Username %s / %s, expired %s',
                    $userIdentifier,
                    $username,
                    $logRow->getUsername(),
                    $logRow->getExpire()->format('c')
                ));
            } else {
                $this->logger->error(sprintf(
                    'Could not find user identifier (%s) in session table! Username %s',
                    $userIdentifier,
                    $username
                ));
            }
        }

        $rows = false === $username ? $rows : array_filter($rows, function(SessionEntity $session) use ($username) {
            return $session->getUsername() === $username;
        });

        if ($usernames !== false && 0 === count($rows)) {
            $this->logger->error(sprintf(
                'Could not find user identifier (%s)! Username %s does not match %s.',
                $userIdentifier,
                $username,
                $usernames
            ));
        }

        return 0 < count($rows) ? reset($rows) : null;
    }
}
