<?php
/**
 * Base entity 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model;

use Sso\WebserviceBundle\Error\Storage as ErrorStorage;

/**
 * Base entity
 */
abstract class Base
{
    /**
     * Errors
     * 
     * @var ErrorStorage
     */
    private $errors;

    /**
     * Get error storage
     * 
     * @return ErrorStorage
     */
    public function errors()
    {
        return $this->errors ? $this->errors : ($this->errors = new ErrorStorage());
    }
}
