<?php

/**
 * Respnose factory 
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id:$
 * @link       http://www.life-style.de
 */

namespace AppBundle\Model\Response;

use AppBundle\Api\Manager as ApiManager;

/**
 * Response factory class
 */
class Factory
{

    /**
     *
     * @var ApiManager
     */
    protected $apiM;

    /**
     * List of factories
     * 
     * @var array
     */
    protected $factories;

    /**
     * Constructor
     * 
     * @param ApiManager $apiM
     */
    public function __construct(ApiManager $apiM)
    {
        $this->apiM = $apiM;
    }

    /**
     * @return \AppBundle\Model\Response\UserIdentifier\Factory
     */
    public function userIdentifier()
    {
        return $this->_getFactory(__NAMESPACE__ . '\UserIdentifier\Factory');
    }

    /**
     * Returns factory
     * 
     * @param string $class
     * @return 
     */
    protected function _getFactory($class)
    {
        return isset($this->factories[$class]) ? $this->factories[$class] : ($this->factories[$class] = new $class($this->apiM));
    }

}
