<?php

/**
 * Steps Index
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Api\Response;

use JMS\Serializer\SerializerInterface;
use Sso\Component\IdentifyServiceBundle\Node;
use Sso\Component\IdentifyServiceBundle\Node\Response as ResponseNode;
use Sso\Component\IdentifyServiceBundle\Node\Manager as NodeManager;
use JMS\Serializer\DeserializationContext;

/**
 * Steps Index
 *
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Index
{

    /**
     *
     * @var SerializerInterface
     */
    private $serializer;

    /**
     *
     * @var NodeManager
     */
    private $nodeManager;

    /**
     *
     * @var ResponseNode
     */
    private $currentResponse;

    /**
     *
     * @var Node\Response\Controller\ActionInterface
     */
    private $currentAction;

    /**
     *
     * @param SerializerInterface $serializer
     */
    public function __construct(SerializerInterface $serializer, NodeManager $nodeManager)
    {
        $this->serializer = $serializer;
        $this->nodeManager = $nodeManager;
    }

    /**
     * Create a new response
     *
     * @return Index
     */
    public function create()
    {
        $this->currentResponse = $this->nodeManager->factory()->response()->setDate(new \DateTime());

        return $this;
    }

    /**
     *
     * @param string $xml
     * @param string $controllerName
     * @param string $actionName
     *
     * @return ResponseNode
     */
    public function read($xml, $controllerName, $actionName)
    {
        $context = DeserializationContext::create()->setGroups(array(
            'Response::Default',
            'Response::' . $controllerName . '::' . $actionName)
        );
        return $this->currentResponse = $this->serializer->deserialize($xml, 'Sso\Component\IdentifyServiceBundle\Node\Response', 'xml', $context);
    }

    /**
     *
     * @param string $status
      v */
    public function setStatus($status)
    {
        $this->currentResponse()->setStatus($status);

        return $this;
    }

    /**
     * Get response status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->currentResponse ? $this->currentResponse->getStatus() : 'Failure';
    }

    /**
     *
     * @param string $trackId
     * @return Index
     */
    public function setTrackId($trackId)
    {
        $this->currentResponse()->setTrackId($trackId);

        return $this;
    }

    /**
     *
     * @param string $status
     * @param string $userIdentifier
     * @param \DateTime $sessionLifetime
     * @return Index
     */
    public function addGetAction($status, $userIdentifier, \DateTime $sessionLifetime = null)
    {
        if (!$this->currentResponse()->getController()) {
            $userIdentifierController = $this->nodeManager->response()->controller()->factory()->userIdentifierController();
            $this->currentResponse()->setUserIdentifierController($userIdentifierController);
        }

        $userType = $this->nodeManager->factory()->userType()
                ->setUserIdentifier($userIdentifier)
                ->setSessionLifetime($sessionLifetime);

        $this->currentAction = $this->nodeManager->response()->controller()->userIdentifierController()->factory()->getAction()
                ->setUserType($userType)
                ->setStatus($status);

        $this->currentResponse()->getController()->addGetAction($this->currentAction);

        return $this;
    }

    /**
     *
     * @param string $status
     * @param string $userIdentifier
     * @param \DateTime $sessionLifetime
     * @return Index
     */
    public function addValidateAction($status, $userIdentifier, \DateTime $sessionLifetime = null)
    {
        if (!$this->currentResponse()->getController()) {
            $userIdentifierController = $this->nodeManager->response()->controller()->factory()->userIdentifierController();
            $this->currentResponse()->setUserIdentifierController($userIdentifierController);
        }

        $userType = $this->nodeManager->factory()->userType()
                ->setUserIdentifier($userIdentifier)
                ->setSessionLifetime($sessionLifetime);

        $this->currentAction = $this->nodeManager->response()->controller()->userIdentifierController()->factory()->validateAction()
                ->setUserType($userType)
                ->setStatus($status);

        $this->currentResponse()->getController()->addValidateAction($this->currentAction);

        return $this;
    }

    /**
     *
     * @param string $errorCode
     * @param string $errorRef
     * @param string $shortMessage
     * @param string $longMessage
     * @return Index
     */
    public function addError($errorCode, $errorRef, $shortMessage, $longMessage)
    {
        if (!$this->currentAction) {
            return;
        }

        $error = $this->nodeManager->response()->factory()->error()
                ->setErrorCode($errorCode)
                ->setErrorRef($errorRef)
                ->setShortMessage($shortMessage)
                ->setLongMessage($longMessage);
        $this->currentAction->addError($error);

        return $this;
    }

    /**
     * Get list of action results
     *
     * @return Node\Response\Controller\ActionInterface[]
     */
    public function getActions()
    {
        return $this->currentResponse ? $this->currentResponse->getController()->getActions() : array();
    }

    /**
     *
     * @return string
     */
    public function buildXml()
    {
        return $this->serializer->serialize($this->currentResponse(), 'xml', $this->currentResponse()->getSerializationContext());
    }

    /**
     *
     * @return ResponseNode
     */
    private function currentResponse()
    {
        return null !== $this->currentResponse ? $this->currentResponse : ($this->currentResponse = $this->create());
    }

}
