<?php

/**
 * Steps Factory
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2015 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\Component\IdentifyServiceBundle\Node;

/**
 * Steps Factory
 * 
 * @copyright  Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Factory
{

    /**
     * Create new request
     * 
     * @return \Sso\Component\IdentifyServiceBundle\Node\Request
     */
    public function request()
    {
        return new Request();
    }

    /**
     * Create new response
     * 
     * @return \Sso\Component\IdentifyServiceBundle\Node\Response
     */
    public function response()
    {
        return new Response();
    }

    /**
     * Create new UserKey node
     * 
     * @return \Sso\Component\IdentifyServiceBundle\Node\UserKey
     */
    public function userKey()
    {
        return new UserKey();
    }

    /**
     * Create new UserType node
     * 
     * @return \Sso\Component\IdentifyServiceBundle\Node\UserType
     */
    public function userType()
    {
        return new UserType();
    }

    /**
     * Create new UserValue node
     * @return \Sso\Component\IdentifyServiceBundle\Node\UserValue
     */
    public function userValue()
    {
        return new UserValue();
    }

}